/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIParticle;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.particles.Emitter;
import me.eccentric_nz.TARDIS.particles.ParticleBlock;
import me.eccentric_nz.TARDIS.particles.ParticleColour;
import me.eccentric_nz.TARDIS.particles.ParticleEffect;
import me.eccentric_nz.TARDIS.particles.ParticleInventory;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.plugin.Plugin;

public class ParticleGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public ParticleGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onParticleClick(InventoryClickEvent event) {
        InventoryView view;
        ItemStack is;
        if (!(event.getInventory().getHolder(false) instanceof ParticleInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (slot >= 0 && slot < 54 && (is = (view = event.getView()).getItem(slot)) != null) {
            ItemMeta im = is.getItemMeta();
            String display = ComponentUtils.stripColour(im.displayName());
            switch (slot) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.setShape(view, slot, display, uuid);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    this.setEffect(view, slot, display, uuid);
                    break;
                }
                case 17: {
                    this.cycleColour(view, uuid);
                    break;
                }
                case 35: {
                    this.cycleBlocks(view, uuid);
                    break;
                }
                case 44: {
                    this.toggle(view, is, uuid);
                    break;
                }
                case 45: {
                    this.less(view, true, uuid);
                    break;
                }
                case 47: {
                    this.more(view, true, uuid);
                    break;
                }
                case 48: {
                    this.test(view, player, uuid);
                    break;
                }
                case 49: {
                    this.less(view, false, uuid);
                    break;
                }
                case 51: {
                    this.more(view, false, uuid);
                    break;
                }
                case 53: {
                    this.close(player);
                    break;
                }
            }
        }
    }

    private void setShape(InventoryView view, int slot, String display, UUID uuid) {
        for (int s = 1; s < 8; ++s) {
            ItemStack is = view.getItem(s);
            if (is == null) continue;
            ItemMeta im = is.getItemMeta();
            ItemStack toSet = ItemStack.of((Material)(s == slot ? Material.LAPIS_ORE : Material.LAPIS_LAZULI));
            toSet.setItemMeta(im);
            view.setItem(s, toSet);
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("shape", display.toUpperCase(Locale.ROOT));
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
    }

    private void setEffect(InventoryView view, int slot, String display, UUID uuid) {
        for (int s = 10; s < 44; ++s) {
            ItemStack is = view.getItem(s);
            if (is == null || s == GUIParticle.COLOUR.slot() || s == GUIParticle.BLOCK_INFO.slot() || s == GUIParticle.BLOCK.slot() || s == GUIParticle.TOGGLE.slot()) continue;
            ItemMeta im = is.getItemMeta();
            ItemStack toSet = ItemStack.of((Material)(s == slot ? Material.REDSTONE_ORE : Material.REDSTONE));
            toSet.setItemMeta(im);
            view.setItem(s, toSet);
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("effect", display.toUpperCase(Locale.ROOT));
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
    }

    private void cycleColour(InventoryView view, UUID uuid) {
        ItemStack is = view.getItem(GUIParticle.COLOUR.slot());
        ItemMeta im = is.getItemMeta();
        Component lore = (Component)im.lore().getFirst();
        NamedTextColor current = ParticleColour.fromComponent(lore);
        int index = ParticleColour.colours.indexOf(current) + 1;
        if (index > 15) {
            index = 0;
        }
        NamedTextColor next = ParticleColour.colours.get(index);
        String colour = ParticleColour.toString(next);
        im.lore(List.of(Component.text((String)colour, (TextColor)next)));
        is.setItemMeta(im);
        view.setItem(GUIParticle.COLOUR.slot(), is);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("colour", colour);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
    }

    private void cycleBlocks(InventoryView view, UUID uuid) {
        ItemStack is = view.getItem(GUIParticle.BLOCK.slot());
        ItemMeta im = is.getItemMeta();
        Component lore = (Component)im.lore().getFirst();
        int index = ParticleBlock.blocks.indexOf(ComponentUtils.stripColour(lore)) + 1;
        if (index > ParticleBlock.blocks.size() - 1) {
            index = 0;
        }
        TextComponent block = Component.text((String)ParticleBlock.blocks.get(index));
        im.lore(List.of(block));
        is.setItemMeta(im);
        view.setItem(GUIParticle.BLOCK.slot(), is);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("block", block);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
    }

    private void toggle(InventoryView view, ItemStack is, UUID uuid) {
        ItemMeta im = is.getItemMeta();
        CustomModelDataComponent component = im.getCustomModelDataComponent();
        boolean on = ((Float)component.getFloats().getFirst()).floatValue() > 200.0f;
        component.setFloats(on ? SwitchVariant.BUTTON_TOGGLE_OFF.getFloats() : SwitchVariant.BUTTON_TOGGLE_ON.getFloats());
        im.setCustomModelDataComponent(component);
        List lore = im.lore();
        lore.set(0, on ? Component.text((String)this.plugin.getLanguage().getString("SET_OFF", "OFF")) : Component.text((String)this.plugin.getLanguage().getString("SET_ON", "ON")));
        im.lore(lore);
        is.setItemMeta(im);
        view.setItem(GUIParticle.TOGGLE.slot(), is);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("particles_on", on ? 0 : 1);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
    }

    private void test(InventoryView view, Player player, UUID uuid) {
        ResultSetCurrentFromId rsc;
        if (this.plugin.getUtils().inTARDISWorld(player)) {
            return;
        }
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        if (rst.fromUUID(uuid.toString()) && (rsc = new ResultSetCurrentFromId(this.plugin, rst.getTardisId())).resultSet()) {
            ResultSetThrottle rs = new ResultSetThrottle(this.plugin);
            Throticle throticle = rs.getSpeedAndParticles(uuid.toString());
            ParticleData data = this.getParticleData(view);
            Emitter emitter = new Emitter(this.plugin, uuid, rsc.getCurrent().location(), data, throticle.throttle().getFlightTime());
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, data.getShape().getPeriod());
            emitter.setTaskID(task);
            this.close(player);
        }
    }

    private ParticleData getParticleData(InventoryView view) {
        ParticleEffect effect = ParticleEffect.ASH;
        ParticleShape shape = ParticleShape.RANDOM;
        boolean b = false;
        try {
            int s;
            for (s = 10; s < 44; ++s) {
                ItemStack eis = view.getItem(s);
                if (eis == null || eis.getType() != Material.REDSTONE_ORE) continue;
                effect = ParticleEffect.valueOf(ComponentUtils.stripColour(eis.getItemMeta().displayName()).toUpperCase(Locale.ROOT));
            }
            for (s = 1; s < 8; ++s) {
                ItemStack sis = view.getItem(s);
                if (sis == null || sis.getType() != Material.LAPIS_ORE) continue;
                shape = ParticleShape.valueOf(ComponentUtils.stripColour(sis.getItemMeta().displayName()).toUpperCase(Locale.ROOT));
            }
        }
        catch (IllegalArgumentException s) {
            // empty catch block
        }
        ItemStack dis = view.getItem(GUIParticle.DENSITY.slot());
        String d = ComponentUtils.stripColour((Component)dis.getItemMeta().lore().getFirst());
        int density = TARDISNumberParsers.parseInt(d);
        ItemStack spis = view.getItem(GUIParticle.SPEED.slot());
        String s = ComponentUtils.stripColour((Component)spis.getItemMeta().lore().getFirst());
        ItemStack cis = view.getItem(GUIParticle.COLOUR.slot());
        String colour = ComponentUtils.stripColour((Component)cis.getItemMeta().lore().getFirst());
        ItemStack bis = view.getItem(GUIParticle.BLOCK.slot());
        String block = ComponentUtils.stripColour((Component)bis.getItemMeta().lore().getFirst());
        double speed = (double)TARDISNumberParsers.parseInt(s) / 10.0;
        return new ParticleData(effect, shape, density, speed, colour, block, b);
    }

    private void less(InventoryView view, boolean density, UUID uuid) {
        int min = density ? 8 : 0;
        int slot = density ? GUIParticle.DENSITY.slot() : GUIParticle.SPEED.slot();
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        int level = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.getFirst()));
        if (--level >= min) {
            lore.set(0, Component.text((int)level, (TextColor)NamedTextColor.AQUA));
            im.lore(lore);
            is.setItemMeta(im);
            view.setItem(slot, is);
            String field = density ? "density" : "speed";
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put(field, level);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
        }
    }

    private void more(InventoryView view, boolean density, UUID uuid) {
        int max = density ? 32 : 10;
        int slot = density ? GUIParticle.DENSITY.slot() : GUIParticle.SPEED.slot();
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        int level = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.getFirst()));
        if (++level <= max) {
            lore.set(0, Component.text((int)level, (TextColor)NamedTextColor.AQUA));
            im.lore(lore);
            is.setItemMeta(im);
            view.setItem(slot, is);
            String f = density ? "density" : "speed";
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put(f, level);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doSyncUpdate("particle_prefs", set, where);
        }
    }
}

