/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.particles.Beam;
import me.eccentric_nz.TARDIS.particles.Falling;
import me.eccentric_nz.TARDIS.particles.Helix;
import me.eccentric_nz.TARDIS.particles.ParticleRunnable;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.TARDIS.particles.Randomish;
import me.eccentric_nz.TARDIS.particles.Rings;
import me.eccentric_nz.TARDIS.particles.Vacuum;
import me.eccentric_nz.TARDIS.particles.Wave;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class Emitter
extends ParticleRunnable
implements Runnable {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Location location;
    private final ParticleData data;
    private final long loops;

    public Emitter(TARDIS plugin, UUID uuid, Location location, ParticleData data, long end) {
        super(plugin, uuid);
        this.plugin = plugin;
        this.uuid = uuid;
        this.location = location.clone().add(0.5, data.getShape().getY(), 0.5);
        this.data = data;
        this.loops = end / data.getShape().getPeriod() + 1L;
    }

    @Override
    public void run() {
        if (this.t < (double)this.loops) {
            ParticleRunnable runnable = switch (this.data.getShape()) {
                case ParticleShape.BEAM -> new Beam(this.plugin, this.uuid, this.data, this.location);
                case ParticleShape.HELIX -> new Helix(this.plugin, this.uuid, this.data, this.location);
                case ParticleShape.RINGS -> new Rings(this.plugin, this.uuid, this.data, this.location);
                case ParticleShape.VACUUM -> new Vacuum(this.plugin, this.uuid, this.data, this.location);
                case ParticleShape.WAVE -> new Wave(this.plugin, this.uuid, this.data, this.location);
                case ParticleShape.FALLING -> new Falling(this.plugin, this.uuid, this.data, this.location);
                default -> new Randomish(this.plugin, this.uuid, this.data, this.location);
            };
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 0L, 1L);
            runnable.setTaskID(task);
            this.t += 1.0;
        } else {
            this.cancel();
        }
    }
}

