/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import com.destroystokyo.paper.MaterialTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class TARDISBeaconColouringListener
implements Listener {
    private final TARDIS plugin;

    public TARDISBeaconColouringListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        Material original;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getBeaconColouring().contains(uuid)) {
            return;
        }
        ItemStack dye = player.getInventory().getItemInMainHand();
        if (!MaterialTags.DYES.isTagged(dye.getType())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COLOUR_DYE");
            return;
        }
        Block b = event.getClickedBlock();
        Material material = original = b != null ? b.getType() : Material.AIR;
        if (!MaterialTags.GLASS.isTagged(original) && !MaterialTags.GLASS_PANES.isTagged(original)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COLOUR_GLASS");
            return;
        }
        boolean found = false;
        for (int i = 1; i < b.getLocation().getBlockY() - 63; ++i) {
            Material mat = b.getRelative(BlockFace.DOWN, i).getType();
            if (!mat.equals((Object)Material.BEACON)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COLOUR_BEACON");
            this.plugin.getTrackerKeeper().getBeaconColouring().remove(uuid);
            return;
        }
        int amount = dye.getAmount();
        switch (original) {
            case BLACK_STAINED_GLASS: 
            case BLACK_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.BLACK_DYE)) break;
                return;
            }
            case BLUE_STAINED_GLASS: 
            case BLUE_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.BLUE_DYE)) break;
                return;
            }
            case BROWN_STAINED_GLASS: 
            case BROWN_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.BROWN_DYE)) break;
                return;
            }
            case CYAN_STAINED_GLASS: 
            case CYAN_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.CYAN_DYE)) break;
                return;
            }
            case GRAY_STAINED_GLASS: 
            case GRAY_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.GRAY_DYE)) break;
                return;
            }
            case GREEN_STAINED_GLASS: 
            case GREEN_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.GREEN_DYE)) break;
                return;
            }
            case LIGHT_BLUE_STAINED_GLASS: 
            case LIGHT_BLUE_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.LIGHT_BLUE_DYE)) break;
                return;
            }
            case LIGHT_GRAY_STAINED_GLASS: 
            case LIGHT_GRAY_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.LIGHT_GRAY_DYE)) break;
                return;
            }
            case LIME_STAINED_GLASS: 
            case LIME_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.LIME_DYE)) break;
                return;
            }
            case MAGENTA_STAINED_GLASS: 
            case MAGENTA_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.MAGENTA_DYE)) break;
                return;
            }
            case ORANGE_STAINED_GLASS: 
            case ORANGE_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.ORANGE_DYE)) break;
                return;
            }
            case PINK_STAINED_GLASS: 
            case PINK_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.PINK_DYE)) break;
                return;
            }
            case PURPLE_STAINED_GLASS: 
            case PURPLE_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.PURPLE_DYE)) break;
                return;
            }
            case RED_STAINED_GLASS: 
            case RED_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.RED_DYE)) break;
                return;
            }
            case WHITE_STAINED_GLASS: 
            case WHITE_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.WHITE_DYE)) break;
                return;
            }
            case YELLOW_STAINED_GLASS: 
            case YELLOW_STAINED_GLASS_PANE: {
                if (!dye.getType().equals((Object)Material.YELLOW_DYE)) break;
                return;
            }
        }
        int u = 1;
        ArrayList<Block> candidates = new ArrayList<Block>();
        candidates.add(b);
        while (b.getRelative(BlockFace.UP, u).getType().equals((Object)original)) {
            candidates.add(b.getRelative(BlockFace.UP, u));
            ++u;
        }
        int needed = candidates.size();
        if (amount < needed) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COLOUR_NOT_ENOUGH", String.format("%d", needed));
            this.plugin.getTrackerKeeper().getBeaconColouring().remove(uuid);
            return;
        }
        if (amount > needed) {
            player.getInventory().getItemInMainHand().setAmount(amount - needed);
        } else {
            player.getInventory().removeItem(new ItemStack[]{ItemStack.of((Material)dye.getType(), (int)needed)});
        }
        player.updateInventory();
        candidates.forEach(bb -> this.changeColour((Block)bb, dye));
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("uuid", uuid.toString());
        int energy = this.plugin.getCondensables().get("GLASS") * needed;
        this.plugin.getQueryFactory().alterEnergyLevel("tardis", -energy, wherea, player);
        this.plugin.getTrackerKeeper().getBeaconColouring().remove(uuid);
    }

    private void changeColour(Block block, ItemStack dye) {
        CharSequence[] b = block.getType().toString().split("_");
        String[] d = dye.getType().toString().split("_");
        if (b.length == 1) {
            b = new String[]{"", "STAINED", "GLASS"};
        } else if (b.length == 2) {
            b = new String[]{"", "STAINED", "GLASS", "PANE"};
        }
        b[0] = d[0];
        String joined = String.join((CharSequence)"_", b);
        BlockData data = Material.valueOf((String)joined).createBlockData();
        block.setBlockData(data, true);
    }
}

