/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.junk;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.control.actions.FindWithJunkAction;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.junk.JunkLocation;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class JunkControlListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<Integer, Integer> repeaterMap = new HashMap();
    private final List<String> worlds;
    private final HashMap<UUID, Integer> worldMap = new HashMap();

    public JunkControlListener(TARDIS plugin) {
        this.plugin = plugin;
        this.repeaterMap.put(1, 1);
        this.repeaterMap.put(2, 10);
        this.repeaterMap.put(3, 100);
        this.repeaterMap.put(4, 1000);
        this.worlds = this.plugin.getTardisAPI().getOverWorlds();
    }

    public static Sign getDestinationSign(int id) {
        Sign sign = null;
        Block b = JunkControlListener.getControlBlock(id, 9);
        if (b != null && Tag.WALL_SIGNS.isTagged((Keyed)b.getType())) {
            sign = (Sign)b.getState();
        }
        return sign;
    }

    private static Block getControlBlock(int id, int type) {
        Block b = null;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("type", type);
        ResultSetControls rs = new ResultSetControls(TARDIS.plugin, where, false);
        if (rs.resultSet()) {
            Location l = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getLocation());
            b = l.getBlock();
        }
        return b;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJunkBrakeUse(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (this.plugin.getGeneralKeeper().isJunkTravelling()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null) {
            Player player;
            int id;
            ResultSetTardisPreset rs;
            ResultSetControls rsh;
            Material blockType = block.getType();
            Location controlLoc = block.getLocation();
            String c_loc = controlLoc.toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("location", c_loc);
            if (blockType == Material.LEVER) {
                where.put("type", 0);
                rsh = new ResultSetControls(this.plugin, where, false);
                if (rsh.resultSet() && (rs = new ResultSetTardisPreset(this.plugin)).fromID(id = rsh.getTardis_id()) && rs.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                    player = event.getPlayer();
                    if (!TARDISPermission.hasPermission(player, "tardis.junk")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_NO_PERM");
                        return;
                    }
                    this.getDestination(id, player);
                    if (this.plugin.getGeneralKeeper().getJunkDestination() != null) {
                        Switch lever;
                        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                        if (!rsc.resultSet()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_NOT_FOUND");
                            return;
                        }
                        Current current = rsc.getCurrent();
                        lever.setPowered(!(lever = (Switch)block.getBlockData()).isPowered());
                        block.setBlockData((BlockData)lever);
                        DestroyData dd = new DestroyData();
                        dd.setPlayer((OfflinePlayer)player);
                        dd.setDirection(COMPASS.SOUTH);
                        dd.setLocation(current.location());
                        dd.setHide(false);
                        dd.setOutside(false);
                        dd.setSubmarine(current.submarine());
                        dd.setTardisID(id);
                        dd.setThrottle(SpaceTimeThrottle.JUNK);
                        this.plugin.getPresetDestroyer().destroyPreset(dd);
                        this.plugin.getGeneralKeeper().setJunkTravelling(true);
                    } else {
                        this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.TARDIS, "JUNK_NO_DEST");
                        return;
                    }
                }
            }
            if (blockType == Material.TRIPWIRE_HOOK) {
                where.put("type", 4);
                ResultSetControls rst = new ResultSetControls(this.plugin, where, false);
                if (rst.resultSet() && (rs = new ResultSetTardisPreset(this.plugin)).fromID(id = rst.getTardis_id()) && rs.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                    player = event.getPlayer();
                    if (!TARDISPermission.hasPermission(player, "tardis.junk")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_NO_PERM");
                        return;
                    }
                    this.setSignWorld(id, player.getUniqueId());
                }
            }
            if (blockType == Material.STONE_BUTTON) {
                where.put("type", 1);
                rsh = new ResultSetControls(this.plugin, where, false);
                if (rsh.resultSet() && (rs = new ResultSetTardisPreset(this.plugin)).fromID(id = rsh.getTardis_id()) && rs.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                    player = event.getPlayer();
                    if (!TARDISPermission.hasPermission(player, "tardis.junk")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_NO_PERM");
                        return;
                    }
                    this.setSignCoords(id, 2);
                }
            }
            if (blockType == Material.OAK_BUTTON) {
                where.put("type", 6);
                rsh = new ResultSetControls(this.plugin, where, false);
                if (rsh.resultSet() && (rs = new ResultSetTardisPreset(this.plugin)).fromID(id = rsh.getTardis_id()) && rs.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                    player = event.getPlayer();
                    if (!TARDISPermission.hasPermission(player, "tardis.junk")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_NO_PERM");
                        return;
                    }
                    this.setSignCoords(id, 3);
                }
            }
            if (blockType == Material.CRIMSON_BUTTON) {
                where.put("type", 52);
                rsh = new ResultSetControls(this.plugin, where, false);
                if (rsh.resultSet() && (rs = new ResultSetTardisPreset(this.plugin)).fromID(id = rsh.getTardis_id()) && rs.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                    new FindWithJunkAction(this.plugin).getNearbyChunkLocation(id, event.getPlayer());
                }
            }
        }
    }

    private void getDestination(int id, Player p) {
        Sign s = JunkControlListener.getDestinationSign(id);
        if (s != null) {
            SignSide front = s.getSide(Side.FRONT);
            String line1 = ComponentUtils.stripColour(front.line(1));
            String line2 = ComponentUtils.stripColour(front.line(2));
            String line3 = ComponentUtils.stripColour(front.line(3));
            if (line1.isEmpty() || line2.isEmpty() || line3.isEmpty()) {
                JunkLocation tjl;
                if (line1.isEmpty() && line2.isEmpty() && line3.isEmpty() && (tjl = new JunkLocation(this.plugin)).isNotHome()) {
                    this.plugin.getGeneralKeeper().setJunkDestination(tjl.getHome());
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "JUNK_RETURN");
                    return;
                }
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "JUNK_LINES");
                return;
            }
            World w = !this.plugin.getPlanetsConfig().getBoolean("planets." + line1 + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getWorld(line1) : TARDISAliasResolver.getWorldFromAlias(line1);
            int x = TARDISNumberParsers.parseInt(line2);
            int z = TARDISNumberParsers.parseInt(line3);
            Chunk chunk = w.getChunkAt(x, z);
            while (!chunk.isLoaded()) {
                w.loadChunk(chunk);
            }
            int y = TARDISStaticLocationGetters.getHighestYin3x3(w, x, z);
            Location d = new Location(w, (double)x, (double)y, (double)z);
            if (this.plugin.getPluginRespect().getRespect(d, new Parameters(p, Flag.getNoMessageFlags()))) {
                while (!chunk.isLoaded()) {
                    chunk.load();
                }
                d.setY((double)this.getActualHighestY(d));
                this.plugin.getGeneralKeeper().setJunkDestination(d);
            }
        }
    }

    private void setSignWorld(int id, UUID uuid) {
        Sign s = JunkControlListener.getDestinationSign(id);
        if (s != null) {
            int pos = 0;
            if (this.worldMap.containsKey(uuid)) {
                int v = this.worldMap.get(uuid);
                pos = v < this.worlds.size() - 1 ? v + 1 : 0;
            }
            this.worldMap.put(uuid, pos);
            s.getSide(Side.FRONT).line(1, (Component)Component.text((String)this.worlds.get(pos)));
            s.update();
        }
    }

    private void setSignCoords(int id, int line) {
        Comparator c;
        Sign s = JunkControlListener.getDestinationSign(id);
        Block rb = JunkControlListener.getControlBlock(id, 2);
        Repeater r = rb != null ? (Repeater)rb.getBlockData() : null;
        Block cb = JunkControlListener.getControlBlock(id, 3);
        Comparator comparator = c = cb != null ? (Comparator)cb.getBlockData() : null;
        if (s != null && r != null && c != null) {
            String txt = ComponentUtils.stripColour(s.getSide(Side.FRONT).line(line));
            if (txt.isEmpty()) {
                txt = "0";
            }
            int multiplier = this.repeaterMap.get(r.getDelay());
            int positiveNegative = c.getMode().equals((Object)Comparator.Mode.COMPARE) ? 1 : -1;
            int current = TARDISNumberParsers.parseInt(txt);
            int amount = current + multiplier * positiveNegative;
            s.getSide(Side.FRONT).line(line, (Component)Component.text((int)amount));
            s.update();
        }
    }

    private int getActualHighestY(Location l) {
        int startz;
        int startx;
        int resetx = startx = l.getBlockX() - 3;
        int starty = l.getBlockY();
        int resetz = startz = l.getBlockZ() - 2;
        for (int level = 0; level < 5; ++level) {
            boolean found = false;
            for (int row = 0; row < 6; ++row) {
                for (int col = 0; col < 6; ++col) {
                    Material mat = l.getWorld().getBlockAt(startx, starty, startz).getType();
                    if (!TARDISConstants.GOOD_MATERIALS.contains(mat)) {
                        found = true;
                    }
                    ++startx;
                }
                startx = resetx;
                ++startz;
            }
            if (!found) {
                return starty;
            }
            startz = resetz;
            ++starty;
        }
        return starty;
    }
}

