/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class SaveLocationCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_]{2,16}");
    private final TARDIS plugin;

    SaveLocationCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean doSave(Player player, String[] args) {
        if (TARDISPermission.hasPermission(player, "tardis.save")) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return false;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            if (!LETTERS_NUMBERS.matcher(args[1]).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NAME_NOT_VALID");
                return false;
            }
            if (args[1].equalsIgnoreCase("hide") || args[1].equalsIgnoreCase("rebuild") || args[1].equalsIgnoreCase("home")) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_RESERVED", "/tardis home", this.plugin);
                return false;
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            CircuitChecker tcc = null;
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, false)) {
                tcc = new CircuitChecker(this.plugin, id);
                tcc.getCircuits();
            }
            if (tcc != null && !tcc.hasMemory()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                return true;
            }
            HashMap<String, Object> wherename = new HashMap<String, Object>();
            wherename.put("tardis_id", id);
            wherename.put("dest_name", args[1]);
            wherename.put("type", 0);
            ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wherename, false);
            if (rsd.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_EXISTS");
                return true;
            }
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            Current current = rsc.getCurrent();
            String w = current.location().getWorld().getName();
            if (w.startsWith("TARDIS_")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NO_TARDIS");
                return true;
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", id);
            set.put("dest_name", args[1]);
            set.put("world", w);
            set.put("x", current.location().getBlockX());
            set.put("y", current.location().getBlockY());
            set.put("z", current.location().getBlockZ());
            set.put("direction", current.direction().toString());
            set.put("submarine", current.submarine() ? 1 : 0);
            if (args.length > 2 && args[2].equalsIgnoreCase("true")) {
                set.put("preset", tardis.getPreset().toString());
            }
            if (this.plugin.getQueryFactory().doSyncInsert("destinations", set) < 0) {
                return false;
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_SET", args[1]);
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

