/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.arch;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.ArchDisguise;
import me.eccentric_nz.TARDIS.arch.ArchLibsDisguise;
import me.eccentric_nz.TARDIS.arch.FobWatchData;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ArchPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public ArchPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "arched (uuid, arch_name, arch_time) VALUES (?, ?, ?)");
            for (Map.Entry<UUID, FobWatchData> map : this.plugin.getTrackerKeeper().getJohnSmith().entrySet()) {
                this.ps = this.connection.prepareStatement("SELECT uuid FROM " + this.prefix + "arched WHERE uuid = ?");
                this.ps.setString(1, map.getKey().toString());
                this.rs = this.ps.executeQuery();
                FobWatchData twd = map.getValue();
                long time = 0L;
                long now = System.currentTimeMillis();
                if (now < twd.getTime()) {
                    time = twd.getTime() - now;
                }
                if (this.rs.next()) {
                    this.ps = this.connection.prepareStatement("UPDATE " + this.prefix + "arched SET arch_name = ?, arch_time = ? WHERE uuid = ?");
                    this.ps.setString(1, twd.getName());
                    this.ps.setLong(2, time);
                    this.ps.setString(3, map.getKey().toString());
                } else {
                    this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "arched (uuid, arch_name, arch_time) VALUES (?, ?, ?)");
                    this.ps.setString(1, map.getKey().toString());
                    this.ps.setString(2, twd.getName());
                    this.ps.setLong(3, time);
                }
                this.count += this.ps.executeUpdate();
            }
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " 'arched' players.");
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for arched table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing arched statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(UUID uuid) {
        try {
            this.ps = this.connection.prepareStatement("SELECT uuid FROM " + this.prefix + "arched WHERE uuid = ?");
            this.ps.setString(1, uuid.toString());
            this.rs = this.ps.executeQuery();
            FobWatchData twd = this.plugin.getTrackerKeeper().getJohnSmith().get(uuid);
            long time = 0L;
            long now = System.currentTimeMillis();
            if (now < twd.getTime()) {
                time = twd.getTime() - now;
            }
            if (this.rs.next()) {
                this.ps = this.connection.prepareStatement("UPDATE " + this.prefix + "arched SET arch_name = ?, arch_time = ? WHERE uuid = ?");
                this.ps.setString(1, twd.getName());
                this.ps.setLong(2, time);
                this.ps.setString(3, uuid.toString());
            } else {
                this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "arched (uuid, arch_name, arch_time) VALUES (?, ?, ?)");
                this.ps.setString(1, uuid.toString());
                this.ps.setString(2, twd.getName());
                this.ps.setLong(3, time);
            }
            this.count += this.ps.executeUpdate();
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " 'arched' player.");
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for arched table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing arched statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reArch(UUID uuid) {
        try {
            Player player;
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "arched WHERE uuid = ?");
            this.ps.setString(1, uuid.toString());
            this.rs = this.ps.executeQuery();
            if (this.rs.next() && (player = this.plugin.getServer().getPlayer(uuid)) != null && player.isOnline()) {
                String name = this.rs.getString("arch_name");
                long time = System.currentTimeMillis() + this.rs.getLong("arch_time");
                FobWatchData twd = new FobWatchData(name, time);
                this.plugin.getTrackerKeeper().getJohnSmith().put(uuid, twd);
                if (this.plugin.isDisguisesOnServer()) {
                    ArchLibsDisguise.undisguise(player);
                } else {
                    ArchDisguise.undisguise(player);
                }
                if (this.plugin.isDisguisesOnServer()) {
                    ArchLibsDisguise.disguise(player, name);
                } else {
                    ArchDisguise.disguise(player, name);
                }
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    TextComponent component = Component.text((String)name);
                    player.displayName((Component)component);
                    player.playerListName((Component)component);
                }, 5L);
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for arched table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing arched statement or resultset: " + ex.getMessage());
            }
        }
    }

    public void checkAll() {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            try {
                this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "arched");
                this.rs = this.ps.executeQuery();
                if (this.rs.isBeforeFirst()) {
                    while (this.rs.next()) {
                        Player player = this.plugin.getServer().getPlayer(UUID.fromString(this.rs.getString("uuid")));
                        if (player == null || !player.isOnline()) continue;
                        String name = this.rs.getString("arch_name");
                        long time = System.currentTimeMillis() + this.rs.getLong("arch_time");
                        FobWatchData twd = new FobWatchData(name, time);
                        this.plugin.getTrackerKeeper().getJohnSmith().put(player.getUniqueId(), twd);
                        if (this.plugin.isDisguisesOnServer()) {
                            ArchLibsDisguise.undisguise(player);
                        } else {
                            ArchDisguise.undisguise(player);
                        }
                        if (this.plugin.isDisguisesOnServer()) {
                            ArchLibsDisguise.disguise(player, name);
                        } else {
                            ArchDisguise.disguise(player, name);
                        }
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            TextComponent component = Component.text((String)name);
                            player.displayName((Component)component);
                            player.playerListName((Component)component);
                        }, 5L);
                    }
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("ResultSet error for arched table: " + ex.getMessage());
            }
            finally {
                try {
                    if (this.ps != null) {
                        this.ps.close();
                    }
                    if (this.rs != null) {
                        this.rs.close();
                    }
                }
                catch (SQLException ex) {
                    this.plugin.debug("Error closing arched statement or resultset: " + ex.getMessage());
                }
            }
        }, 30L);
    }

    void removeArch(UUID uuid) {
        try {
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "arched WHERE uuid = ?");
            this.ps.setString(1, uuid.toString());
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for arched table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing arched statement or resultset: " + ex.getMessage());
            }
        }
    }
}

