/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.nms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.nms.TWAJudoon;
import me.eccentric_nz.tardisweepingangels.nms.TWAOod;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;

public class FollowerPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;

    public FollowerPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(TWAFollower follower) {
        try {
            CraftPersistentDataContainer pdc = follower.getBukkitEntity().getPersistentDataContainer();
            String uuid = follower.getUUID().toString();
            String owner = follower.getOwnerUUID() != null ? follower.getOwnerUUID().toString() : TARDISWeepingAngels.UNCLAIMED.toString();
            String species = "";
            int following = follower.isFollowing() ? 1 : 0;
            String colour = "BLACK";
            int option = 0;
            int ammo = 0;
            if (pdc.has(TARDISWeepingAngels.OOD, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                species = "OOD";
                TWAOod ood = (TWAOod)follower;
                colour = ood.getColour().toString();
                option = ood.isRedeye() ? 1 : 0;
                uuid = ((UUID)pdc.getOrDefault(TARDISWeepingAngels.OOD, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)follower.getUUID())).toString();
            }
            if (pdc.has(TARDISWeepingAngels.JUDOON, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                species = "JUDOON";
                TWAJudoon judoon = (TWAJudoon)follower;
                ammo = judoon.getAmmo();
                option = judoon.isGuard() ? 1 : 0;
                uuid = ((UUID)pdc.getOrDefault(TARDISWeepingAngels.JUDOON, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)follower.getUUID())).toString();
            }
            if (pdc.has(TARDISWeepingAngels.K9, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                species = "K9";
                uuid = ((UUID)pdc.getOrDefault(TARDISWeepingAngels.K9, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)follower.getUUID())).toString();
            }
            this.ps = this.connection.prepareStatement("REPLACE INTO " + this.prefix + "followers (`uuid`, `owner`, `species`, `following`, `option`, `colour`, `ammo`) VALUES (?, ?, ?, ?, ?, ?, ?)");
            this.ps.setString(1, uuid);
            this.ps.setString(2, owner);
            this.ps.setString(3, species);
            this.ps.setInt(4, following);
            this.ps.setInt(5, option);
            this.ps.setString(6, colour);
            this.ps.setInt(7, ammo);
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("Upsert error for follower persistence: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing follower persistence statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Follower follower, UUID uuid) {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "followers (`uuid`, `owner`, `species`, `following`, `option`, `colour`, `ammo`) VALUES (?, ?, ?, ?, ?, ?, ?)");
            this.ps.setString(1, uuid.toString());
            this.ps.setString(2, follower.getOwner().toString());
            this.ps.setString(3, follower.getSpecies().toString());
            this.ps.setInt(4, follower.isFollowing() ? 1 : 0);
            this.ps.setInt(5, follower.hasOption() ? 1 : 0);
            this.ps.setString(6, follower.getColour().toString());
            this.ps.setInt(7, follower.getAmmo());
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for follower persistence: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing follower persistence statement: " + ex.getMessage());
            }
        }
    }
}

