/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisregeneration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRegenerations;
import me.eccentric_nz.TARDIS.doors.DoorUtility;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisregeneration.UntemperedSchism;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class UntemperedSchismListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<UUID, Location> untempered = new HashMap();
    private final Set<Vector> vectorsEW = new HashSet<Vector>();
    private final Set<Vector> vectorsNS = new HashSet<Vector>();

    public UntemperedSchismListener(TARDIS plugin) {
        this.plugin = plugin;
        this.vectorsEW.add(new Vector(0, 1, 0));
        this.vectorsEW.add(new Vector(0, 2, 0));
        this.vectorsEW.add(new Vector(-1, 0, 0));
        this.vectorsEW.add(new Vector(-1, 1, 0));
        this.vectorsEW.add(new Vector(-1, 2, 0));
        this.vectorsEW.add(new Vector(1, 0, 0));
        this.vectorsEW.add(new Vector(1, 1, 0));
        this.vectorsEW.add(new Vector(1, 2, 0));
        this.vectorsNS.add(new Vector(0, 1, 0));
        this.vectorsNS.add(new Vector(0, 2, 0));
        this.vectorsNS.add(new Vector(0, 0, -1));
        this.vectorsNS.add(new Vector(0, 1, -1));
        this.vectorsNS.add(new Vector(0, 2, -1));
        this.vectorsNS.add(new Vector(0, 0, 1));
        this.vectorsNS.add(new Vector(0, 1, 1));
        this.vectorsNS.add(new Vector(0, 2, 1));
    }

    @EventHandler
    public void onUntemperedSchismPlace(BlockPlaceEvent event) {
        Player player;
        BlockFace facing;
        ItemStack schism = event.getItemInHand();
        if (!UntemperedSchism.is(schism)) {
            return;
        }
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (!this.hasSpace(location, (facing = (player = event.getPlayer()).getFacing()) == BlockFace.EAST || facing == BlockFace.WEST ? this.vectorsEW : this.vectorsNS)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "UNTEMPERED_SCHISM_SPACE");
            event.setCancelled(true);
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            block.setType(Material.AIR);
            ItemDisplay display = TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.UNTEMPERED_SCHISM, block, -1);
            float yaw = DoorUtility.getLookAtYaw(player);
            display.setRotation(yaw, 0.0f);
            this.untempered.put(player.getUniqueId(), location);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "UNTEMPERED_SCHISM_WALK");
        }, 1L);
    }

    @EventHandler
    public void onEnterUntemperedSchism(PlayerMoveEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (!this.untempered.containsKey(uuid)) {
            return;
        }
        Location to = event.getTo();
        if (!this.matchesLocation(to, this.untempered.get(uuid))) {
            return;
        }
        ResultSetRegenerations rsr = new ResultSetRegenerations(this.plugin);
        if (rsr.fromUUID(uuid.toString()) && rsr.getCount() > 0) {
            this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.REGENERATION, "UNTEMPERED_SCHISM_LEFT", rsr.getCount());
            to.getWorld().dropItemNaturally(to, UntemperedSchism.create());
        } else {
            to.getWorld().createExplosion(to, 0.0f, false, false);
            int reset = this.plugin.getRegenerationConfig().getInt("regenerations", 15);
            this.plugin.getQueryFactory().setRegenerationCount(uuid, reset);
            this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.REGENERATION, "UNTEMPERED_SCHISM_RESET", reset);
        }
        Block block = to.getBlock();
        TARDISDisplayItemUtils.remove(block);
        block.setType(Material.AIR);
        this.untempered.remove(uuid);
    }

    private boolean matchesLocation(Location to, Location location) {
        return to.getBlockX() == location.getBlockX() && to.getBlockY() == location.getBlockY() && to.getBlockZ() == location.getBlockZ();
    }

    private boolean hasSpace(Location location, Set<Vector> vectors) {
        for (Vector v : vectors) {
            location.add(v);
            if (!location.getBlock().getType().isAir()) {
                return false;
            }
            location.subtract(v);
        }
        return true;
    }
}

