/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISArmourStandDisguiser;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiseListener;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiser;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISPlayerDisguiser;
import me.eccentric_nz.TARDIS.skins.ChameleonArchDisguiser;
import me.eccentric_nz.tardischunkgenerator.custombiome.CubicMaterial;
import me.eccentric_nz.tardischunkgenerator.custombiome.CustomBiome;
import me.eccentric_nz.tardischunkgenerator.custombiome.CustomBiomeData;
import me.eccentric_nz.tardischunkgenerator.custombiome.TARDISBiomeData;
import me.eccentric_nz.tardischunkgenerator.helpers.GetBlockColours;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISItemFrameFaker;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISMapUpdater;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISPlanetData;
import me.eccentric_nz.tardischunkgenerator.logging.TARDISLogFilter;
import me.eccentric_nz.tardischunkgenerator.worldgen.feature.CustomTree;
import me.eccentric_nz.tardischunkgenerator.worldgen.feature.TARDISTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftVillager;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Listener;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TARDISHelper {
    public static final HashMap<String, Biome> biomeMap = new HashMap();
    public static boolean colourSkies;
    private final TARDIS plugin;

    public TARDISHelper(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void enable() {
        if (this.plugin.getConfig().getBoolean("debug")) {
            String basePath = String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + "plugins" + File.separator + "TARDIS" + File.separator;
            this.filterLog(basePath + "filtered.log");
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Starting filtered logging for TARDIS...");
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Log file located at 'plugins/TARDIS/filtered.log'");
        }
        boolean aPlanetIsEnabled = false;
        if (this.plugin.getPlanetsConfig().getBoolean("planets.gallifrey.enabled")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Adding custom biome for planet Gallifrey...");
            CustomBiome.addCustomBiome(TARDISBiomeData.BADLANDS);
            aPlanetIsEnabled = true;
        }
        if (this.plugin.getPlanetsConfig().getBoolean("planets.skaro.enabled")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Adding custom biome for planet Skaro...");
            CustomBiome.addCustomBiome(TARDISBiomeData.DESERT);
            aPlanetIsEnabled = true;
        }
        colourSkies = aPlanetIsEnabled && this.plugin.getPlanetsConfig().getBoolean("colour_skies");
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new TARDISDisguiseListener(this.plugin), (Plugin)this.plugin);
    }

    public void nameFurnaceGUI(Block block, String name) {
        BlockPos bp;
        ServerLevel ws;
        BlockEntity tile;
        if (block != null && (tile = (ws = ((CraftWorld)block.getWorld()).getHandle()).getBlockEntity(bp = new BlockPos(block.getX(), block.getY(), block.getZ()))) instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)tile;
            furnace.name = Component.literal((String)name);
        }
    }

    public boolean isArtronFurnace(Block block) {
        FurnaceBlockEntity furnace;
        BlockPos bp;
        ServerLevel ws;
        BlockEntity tile;
        if (block != null && (tile = (ws = ((CraftWorld)block.getWorld()).getHandle()).getBlockEntity(bp = new BlockPos(block.getX(), block.getY(), block.getZ()))) instanceof FurnaceBlockEntity && (furnace = (FurnaceBlockEntity)tile).getCustomName() != null) {
            return furnace.getCustomName().getString().equals("TARDIS Artron Furnace");
        }
        return false;
    }

    public void setLevelName(String oldName, String newName) {
        File file = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + oldName + File.separator + "level.dat");
        if (file.exists()) {
            try (FileInputStream fileinputstream = new FileInputStream(file);){
                CompoundTag tagCompound = NbtIo.readCompressed((InputStream)fileinputstream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                if (tagCompound.getCompound("Data").isPresent()) {
                    CompoundTag data = (CompoundTag)tagCompound.getCompound("Data").get();
                    data.putString("LevelName", newName);
                    tagCompound.put("Data", (Tag)data);
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    NbtIo.writeCompressed((CompoundTag)tagCompound, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Renamed level to " + newName);
                    File directory = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + oldName);
                    File folder = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + newName);
                    if (directory.renameTo(folder)) {
                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Renamed directory to " + newName);
                    }
                }
            }
            catch (IOException ex) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER_SEVERE, ex.getMessage());
            }
        }
    }

    public void setWorldGameMode(String world, GameMode gm) {
        File file = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + world + File.separator + "level.dat");
        if (file.exists()) {
            try (FileInputStream fileinputstream = new FileInputStream(file);){
                CompoundTag tagCompound = NbtIo.readCompressed((InputStream)fileinputstream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                if (tagCompound.getCompound("Data").isPresent()) {
                    CompoundTag data = (CompoundTag)tagCompound.getCompound("Data").get();
                    int mode = switch (gm) {
                        case GameMode.CREATIVE -> 1;
                        case GameMode.ADVENTURE -> 2;
                        case GameMode.SPECTATOR -> 3;
                        default -> 0;
                    };
                    data.putInt("GameType", mode);
                    tagCompound.put("Data", (Tag)data);
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    NbtIo.writeCompressed((CompoundTag)tagCompound, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
            }
            catch (IOException ex) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER_SEVERE, ex.getMessage());
            }
        }
    }

    public TARDISPlanetData getLevelData(String world) {
        File file = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + world + File.separator + "level.dat");
        if (file.exists()) {
            try {
                FileInputStream fileinputstream = new FileInputStream(file);
                CompoundTag tagCompound = NbtIo.readCompressed((InputStream)fileinputstream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                fileinputstream.close();
                GameMode gameMode = GameMode.SURVIVAL;
                WorldType worldType = WorldType.NORMAL;
                World.Environment environment = World.Environment.NORMAL;
                Difficulty difficulty = Difficulty.NORMAL;
                if (tagCompound.getCompound("Data").isPresent()) {
                    CompoundTag data = (CompoundTag)tagCompound.getCompound("Data").get();
                    if (data.getInt("GameType").isPresent()) {
                        int gm = (Integer)data.getInt("GameType").get();
                        switch (gm) {
                            case 1: {
                                GameMode gameMode2 = GameMode.CREATIVE;
                                break;
                            }
                            case 2: {
                                GameMode gameMode2 = GameMode.ADVENTURE;
                                break;
                            }
                            case 3: {
                                GameMode gameMode2 = GameMode.SPECTATOR;
                                break;
                            }
                            default: {
                                GameMode gameMode2 = gameMode = GameMode.SURVIVAL;
                            }
                        }
                    }
                    if (data.getString("generatorName").isPresent()) {
                        String wt = (String)data.getString("generatorName").get();
                        worldType = switch (wt.toLowerCase(Locale.ROOT)) {
                            case "flat" -> WorldType.FLAT;
                            case "largebiomes" -> WorldType.LARGE_BIOMES;
                            case "amplified" -> WorldType.AMPLIFIED;
                            default -> WorldType.NORMAL;
                        };
                    }
                    File dimDashOne = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + world + File.separator + "DIM-1");
                    File dimOne = new File(Bukkit.getWorldContainer().getAbsolutePath() + File.separator + world + File.separator + "DIM1");
                    if (dimDashOne.exists() && !dimOne.exists()) {
                        environment = World.Environment.NETHER;
                    }
                    if (dimOne.exists() && !dimDashOne.exists()) {
                        environment = World.Environment.THE_END;
                    }
                    if (data.getInt("Difficulty").isPresent()) {
                        int diff = (Integer)data.getInt("Difficulty").get();
                        switch (diff) {
                            case 0: {
                                difficulty = Difficulty.PEACEFUL;
                                break;
                            }
                            case 1: {
                                difficulty = Difficulty.EASY;
                                break;
                            }
                            case 3: {
                                difficulty = Difficulty.HARD;
                                break;
                            }
                        }
                    }
                }
                return new TARDISPlanetData(gameMode, environment, worldType, difficulty);
            }
            catch (IOException ex) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER_SEVERE, ex.getMessage());
                return new TARDISPlanetData(GameMode.SURVIVAL, World.Environment.NORMAL, WorldType.NORMAL, Difficulty.NORMAL);
            }
        }
        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER, "Defaulted to GameMode.SURVIVAL, World.Environment.NORMAL, WorldType.NORMAL");
        return new TARDISPlanetData(GameMode.SURVIVAL, World.Environment.NORMAL, WorldType.NORMAL, Difficulty.NORMAL);
    }

    public void disguise(EntityType entityType, Player player) {
        new TARDISDisguiser(entityType, player).disguiseToAll();
    }

    public void disguise(EntityType entityType, Player player, Object[] options) {
        new TARDISDisguiser(entityType, player, options).disguiseToAll();
    }

    public void disguise(Player player, String name) {
        new ChameleonArchDisguiser(this.plugin, player).changeSkin(name);
    }

    public void disguise(Player player, UUID uuid) {
        new TARDISPlayerDisguiser(player, uuid);
    }

    public void undisguise(Player player) {
        new TARDISDisguiser(player).removeDisguise();
    }

    public void disguiseArmourStand(ArmorStand stand, EntityType entityType, Object[] options) {
        new TARDISArmourStandDisguiser(stand, entityType, options).disguiseToAll();
    }

    public void undisguiseArmourStand(ArmorStand stand) {
        TARDISArmourStandDisguiser.removeDisguise(stand);
    }

    public void updateMap(World world, MapView mapView) {
        new TARDISMapUpdater(world).update(mapView);
    }

    public void addCustomBiome(String biome) {
        CustomBiomeData data = biome.equalsIgnoreCase("gallifrey") ? TARDISBiomeData.BADLANDS : (biome.equalsIgnoreCase("skaro") ? TARDISBiomeData.DESERT : TARDISBiomeData.EYE);
        CustomBiome.addCustomBiome(data);
    }

    public void removeTileEntity(BlockState tile) {
        BlockPos position = new BlockPos(tile.getLocation().getBlockX(), tile.getLocation().getBlockY(), tile.getLocation().getBlockZ());
        ServerLevel level = ((CraftWorld)tile.getLocation().getWorld()).getHandle();
        ChunkAccess chunk = level.getChunk(position);
        chunk.removeBlockEntity(position);
        tile.getBlock().setType(Material.AIR);
    }

    public void setPowerableBlockInteract(Block block) {
        Direction direction = Direction.NORTH;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Directional) {
            Directional directional = (Directional)blockData;
            direction = Direction.byName((String)directional.getFacing().toString().toLowerCase(Locale.ROOT));
        }
        net.minecraft.world.level.block.state.BlockState data = ((CraftBlock)block).getNMS();
        ServerLevel world = ((CraftWorld)block.getWorld()).getHandle();
        BlockPos position = ((CraftBlock)block).getPosition();
        data.useWithoutItem((Level)world, null, BlockHitResult.miss((Vec3)data.getOffset(position), (Direction)direction, (BlockPos)position));
    }

    public void growTree(String tree, Location location) {
        try {
            TARDISTree type = TARDISTree.valueOf(tree.toUpperCase(Locale.ROOT));
            CustomTree.grow(type, location);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER_WARNING, "Invalid TARDISTree type specified!");
        }
    }

    public void growTree(Location location, Material base, Material hat, Material stem, Material decor) {
        CustomTree.grow(location, base, hat, stem, decor);
    }

    public List<Material> getTreeMaterials() {
        return CubicMaterial.cubes;
    }

    public int[] getReputation(Villager villager, UUID uuid) {
        net.minecraft.world.entity.npc.villager.Villager v = ((CraftVillager)villager).getHandle();
        GossipContainer entries = v.getGossips();
        int[] reputation = new int[5];
        reputation[GossipType.MAJOR_NEGATIVE.ordinal()] = entries.getReputation(uuid, gossipType -> gossipType == GossipType.MAJOR_NEGATIVE);
        reputation[GossipType.MINOR_NEGATIVE.ordinal()] = entries.getReputation(uuid, gossipType -> gossipType == GossipType.MINOR_NEGATIVE);
        reputation[GossipType.MINOR_POSITIVE.ordinal()] = entries.getReputation(uuid, gossipType -> gossipType == GossipType.MINOR_POSITIVE);
        reputation[GossipType.MAJOR_POSITIVE.ordinal()] = entries.getReputation(uuid, gossipType -> gossipType == GossipType.MAJOR_POSITIVE);
        reputation[GossipType.TRADING.ordinal()] = entries.getReputation(uuid, gossipType -> gossipType == GossipType.TRADING);
        return reputation;
    }

    public void setReputation(Villager villager, UUID uuid, int[] reputation) {
        net.minecraft.world.entity.npc.villager.Villager v = ((CraftVillager)villager).getHandle();
        GossipContainer entries = v.getGossips();
        entries.add(uuid, GossipType.MAJOR_NEGATIVE, reputation[GossipType.MAJOR_NEGATIVE.ordinal()]);
        entries.add(uuid, GossipType.MINOR_NEGATIVE, reputation[GossipType.MINOR_NEGATIVE.ordinal()]);
        entries.add(uuid, GossipType.MINOR_POSITIVE, reputation[GossipType.MINOR_POSITIVE.ordinal()]);
        entries.add(uuid, GossipType.MAJOR_POSITIVE, reputation[GossipType.MAJOR_POSITIVE.ordinal()]);
        entries.add(uuid, GossipType.TRADING, reputation[GossipType.TRADING.ordinal()]);
    }

    public int castFakeItemFrame(ItemFrame frame, Player player, Vector location) {
        return TARDISItemFrameFaker.cast(frame, player, location);
    }

    public void removeFakeItemFrame(int id, Player player) {
        TARDISItemFrameFaker.remove(id, player);
    }

    public void filterLog(String path) {
        ((Logger)LogManager.getRootLogger()).addFilter((Filter)new TARDISLogFilter(path));
    }

    public void listBlockColours() {
        GetBlockColours.list();
    }
}

