/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.archive;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ArchiveUpdate {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String uuid;
    private final String name;
    private final String prefix;

    public ArchiveUpdate(TARDIS plugin, String uuid, String name) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.name = name;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInUse() {
        PreparedStatement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        String query = "SELECT archive_id, name, use FROM " + this.prefix + "archive WHERE uuid = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, this.uuid);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                String update = "UPDATE " + this.prefix + "archive SET use = ? WHERE archive_id = ?";
                ps = this.connection.prepareStatement(update);
                while (rs.next()) {
                    int i = 0;
                    if (rs.getString("name").equals(this.name)) {
                        i = 1;
                    }
                    if (rs.getInt("use") == 1) {
                        i = 2;
                    }
                    ps.setInt(1, i);
                    ps.setInt(2, rs.getInt("archive_id"));
                    ps.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for archive update! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing archive update! " + e.getMessage());
            }
        }
    }
}

