/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.architectural.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.Branch;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.Leaf;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.TreeVector;

public class Tree {
    public final List<Branch> branches = new ArrayList<Branch>();
    public final List<Leaf> leaves = new ArrayList<Leaf>();
    public final List<Branch> stems = new ArrayList<Branch>();
    private final int leafWidth;
    private final int leafHeight;
    private final int leafDensity;
    private final int branchMinLength;
    private final int branchMaxLength;
    private final int stemLength;
    private final int branchThickness;

    public Tree(int leafWidth, int leafHeight, int leafDensity, int branchMinLength, int branchMaxLength, int stemLength, int branchThickness) {
        this.leafWidth = leafWidth;
        this.leafHeight = leafHeight;
        this.leafDensity = leafDensity;
        this.branchMinLength = branchMinLength;
        this.branchMaxLength = branchMaxLength;
        this.stemLength = stemLength;
        this.branchThickness = branchThickness;
    }

    public void createTree() {
        this.fractalTree();
    }

    private void fractalTree() {
        int i;
        Random rand = new Random();
        rand.setSeed(System.currentTimeMillis());
        for (i = 0; i < this.leafDensity; ++i) {
            this.leaves.add(new Leaf(new TreeVector(rand.nextInt(this.leafWidth) - Math.round((float)this.leafWidth / 2.0f), rand.nextInt(this.leafHeight - this.stemLength) + this.stemLength, rand.nextInt(this.leafWidth) - Math.round((float)this.leafWidth / 2.0f))));
        }
        for (i = 0; i < this.branchThickness; ++i) {
            for (int j = 0; j < this.branchThickness; ++j) {
                Branch root = new Branch(null, new TreeVector(0.0, 1.0, 0.0), new TreeVector(i - Math.round((float)this.branchThickness / 2.0f), -2.0, j - Math.round((float)this.branchThickness / 2.0f)));
                this.branches.add(root);
                Branch current = new Branch(root);
                while (!this.closeEnough(current)) {
                    Branch trunk = new Branch(current);
                    this.branches.add(trunk);
                    current = trunk;
                }
                this.stems.add(current);
            }
        }
    }

    private boolean closeEnough(Branch branch) {
        for (Leaf leaf : this.leaves) {
            double d = TreeVector.distance(branch.getPosition(), leaf.getPosition());
            if (!(d < (double)this.branchMaxLength)) continue;
            return true;
        }
        return false;
    }

    public void grow() {
        int i;
        for (i = 0; i < this.leaves.size(); ++i) {
            Leaf l = this.leaves.get(i);
            Branch closestBranch = null;
            TreeVector closestDir = null;
            double record = 100000.0;
            for (Branch b : this.branches) {
                TreeVector dir = TreeVector.sub(l.getPosition(), b.getPosition());
                double d = TreeVector.length(dir);
                if (d < (double)this.branchMinLength) {
                    l.reached = true;
                    closestBranch = null;
                    break;
                }
                if (!(d <= (double)this.branchMaxLength) || closestBranch != null && !(d < record)) continue;
                closestBranch = b;
                closestDir = dir;
                record = d;
            }
            if (closestBranch == null) continue;
            for (Branch stem : this.stems) {
                TreeVector stemDir = TreeVector.sub(l.getPosition(), stem.getPosition());
                stemDir = TreeVector.normalize(stemDir);
                TreeVector ve = TreeVector.add(stem.getDirection(), stemDir);
                stem = new Branch(stem.getParent(), ve, stem.getPosition());
                stem.setDirection(TreeVector.add(stemDir, stem.getDirection()));
                ++stem.count;
                this.branches.add(stem);
            }
            this.stems.clear();
            closestDir = TreeVector.normalize(closestDir);
            TreeVector v = TreeVector.add(closestBranch.getDirection(), closestDir);
            closestBranch = new Branch(closestBranch.getParent(), v, closestBranch.getPosition());
            closestBranch.setDirection(TreeVector.add(closestDir, closestBranch.getDirection()));
            ++closestBranch.count;
            this.branches.add(closestBranch);
        }
        for (i = this.leaves.size() - 1; i >= 0; --i) {
            if (!this.leaves.get((int)i).reached) continue;
            this.leaves.remove(i);
        }
        for (i = this.branches.size() - 1; i >= 0; --i) {
            Branch b = this.branches.get(i);
            if (b.count <= 0) continue;
            b.setDirection(TreeVector.div(b.getDirection(), b.count));
            b.setDirection(TreeVector.normalize(b.getDirection()));
            Branch newB = new Branch(b);
            this.branches.add(newB);
            b.reset();
        }
    }
}

