/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.architectural;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlueprint;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rooms.architectural.ArchitecturalBlueprintsInventory;
import me.eccentric_nz.TARDIS.rooms.architectural.TreeBlueprints;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ArchitecturalBlueprintsListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> selected_slot = new HashMap();
    private final HashMap<UUID, Integer> selected_player = new HashMap();
    private final HashMap<UUID, Integer> scroll = new HashMap();
    private final HashMap<UUID, Integer> scroll_start = new HashMap();
    private final List<UUID> scrolling = new ArrayList<UUID>();
    private final int rows;
    private final ItemStack[][] blueprints;
    private List<Player> players;

    public ArchitecturalBlueprintsListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.rows = BlueprintRoom.PERMS.size() / 9 + 1;
        this.blueprints = TreeBlueprints.getBlueprints();
    }

    @EventHandler
    public void onArchitecturalBlueprintClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ArchitecturalBlueprintsInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        ItemStack is = event.getView().getItem(slot);
        if (is == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        InventoryView view = event.getView();
        switch (slot) {
            case 27: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scrollDisks(view, this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 28: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scrollDisks(view, this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                ItemStack head = event.getView().getItem(slot);
                if (head.getType() != Material.PLAYER_HEAD) break;
                this.selected_player.put(uuid, slot);
                break;
            }
            case 45: {
                int startl;
                if (this.players.size() <= 9) break;
                int max = this.players.size() - 9;
                if (this.scroll_start.containsKey(uuid)) {
                    startl = this.scroll_start.get(uuid) + 1;
                    if (startl >= max) {
                        startl = max;
                    }
                } else {
                    startl = 1;
                }
                this.scroll_start.put(uuid, startl);
                for (int i = 0; i < 9; ++i) {
                    this.setPlayerSlot(view, 36 + i, this.players.get(startl + i));
                }
                break;
            }
            case 46: {
                int startr;
                if (this.players.size() <= 9) break;
                if (this.scroll_start.containsKey(uuid)) {
                    startr = this.scroll_start.get(uuid) - 1;
                    if (startr <= 0) {
                        startr = 0;
                    }
                } else {
                    startr = 0;
                }
                this.scroll_start.put(uuid, startr);
                for (int i = 0; i < 9; ++i) {
                    this.setPlayerSlot(view, 36 + i, this.players.get(startr + i));
                }
                break;
            }
            case 49: {
                if (!this.selected_slot.containsKey(uuid) || !this.selected_player.containsKey(uuid)) break;
                ItemStack room = view.getItem(this.selected_slot.get(uuid).intValue());
                ItemMeta rim = room.getItemMeta();
                PersistentDataContainer pdc = rim.getPersistentDataContainer();
                String perm = (String)pdc.get(TARDIS.plugin.getBlueprintKey(), PersistentDataType.STRING);
                ItemStack head = view.getItem(this.selected_player.get(uuid).intValue());
                UUID receiver = UUID.fromString(ComponentUtils.stripColour((Component)head.getItemMeta().lore().getFirst()));
                if (!TARDISPermission.hasPermission(receiver, perm)) {
                    ItemStack gift = room.clone();
                    ItemMeta gim = gift.getItemMeta();
                    gim.getPersistentDataContainer().set(TARDIS.plugin.getTimeLordUuidKey(), TARDIS.plugin.getPersistentDataTypeUUID(), (Object)receiver);
                    List lore = gim.lore();
                    lore.add(Component.text((String)"Valid only for"));
                    lore.add(Component.text((String)player.getName()));
                    gim.lore(lore);
                    gift.setItemMeta(gim);
                    Player recipient = this.plugin.getServer().getPlayer(receiver);
                    if (recipient == null || !recipient.isOnline()) break;
                    recipient.give(new ItemStack[]{gift});
                    String r = ComponentUtils.stripColour(gim.displayName());
                    this.plugin.getMessenger().send((CommandSender)recipient, TardisModule.TARDIS, "GIVE_ITEM", player.getName(), "a " + r + " Blueprint Disk");
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BLUEPRINT_HAS");
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                ItemStack disk = view.getItem(slot);
                if (disk.getType() == Material.MUSIC_DISC_MELLOHI) {
                    this.selected_slot.put(uuid, slot);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BLUEPRINT_NOT_GRANTED");
            }
        }
    }

    private void setPlayerSlot(InventoryView view, int slot, Player player) {
        ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD, (int)1);
        SkullMeta skull = (SkullMeta)head.getItemMeta();
        skull.setOwningPlayer((OfflinePlayer)player);
        skull.displayName((Component)Component.text((String)player.getName()));
        skull.lore(List.of(Component.text((String)player.getUniqueId().toString())));
        head.setItemMeta((ItemMeta)skull);
        view.setItem(slot, head);
    }

    private void scrollDisks(InventoryView view, int row, boolean up, UUID uuid) {
        if (up && row < this.rows - 2 || !up && row >= 0) {
            this.scroll.put(uuid, row);
            this.setDiskSlots(view, row, uuid);
        } else {
            this.scrolling.remove(uuid);
        }
    }

    private void setDiskSlots(InventoryView view, int row, UUID uuid) {
        ResultSetBlueprint rsb = new ResultSetBlueprint(this.plugin);
        List<String> perms = rsb.getRoomBlueprints(uuid.toString());
        int slot = 0;
        for (int r = row; r < row + 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                ItemStack is = this.blueprints[r][c];
                if (is != null) {
                    ItemMeta im = is.getItemMeta();
                    PersistentDataContainer pdc = im.getPersistentDataContainer();
                    String perm = (String)pdc.get(TARDIS.plugin.getBlueprintKey(), PersistentDataType.STRING);
                    if (!perms.contains(perm)) {
                        view.setItem(slot, is.withType(Material.MUSIC_DISC_RELIC));
                    } else {
                        view.setItem(slot, is);
                    }
                } else {
                    view.setItem(slot, null);
                }
                ++slot;
            }
        }
        this.scrolling.remove(uuid);
    }

    @EventHandler
    public void onBlueprintMenuOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof ArchitecturalBlueprintsInventory) {
            Player p = (Player)event.getPlayer();
            this.scroll.put(p.getUniqueId(), 0);
            this.players = new ArrayList<Player>(this.plugin.getServer().getOnlinePlayers());
            this.players.remove(p);
        }
    }
}

