/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.lazarus.LazarusVariants;
import me.eccentric_nz.TARDIS.planets.GallifreyBlueprintTrade;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Merchant;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class TARDISGallifreySpawnListener
implements Listener {
    private final TARDIS plugin;

    public TARDISGallifreySpawnListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGallifreyanSpawn(CreatureSpawnEvent event) {
        if (!event.getLocation().getWorld().getName().endsWith("gallifrey")) {
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = event.getSpawnReason();
        if (!this.plugin.getPlanetsConfig().getBoolean("planets.gallifrey.spawn_other_mobs") && spawnReason != CreatureSpawnEvent.SpawnReason.SPAWNER && spawnReason != CreatureSpawnEvent.SpawnReason.CUSTOM) {
            event.setCancelled(true);
            return;
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            if (!event.getEntity().getType().equals((Object)EntityType.VILLAGER)) {
                return;
            }
            LivingEntity le = event.getEntity();
            Villager villager = (Villager)le;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                villager.setProfession(LazarusVariants.VILLAGER_PROFESSIONS.get(TARDISConstants.RANDOM.nextInt(LazarusVariants.VILLAGER_PROFESSIONS.size())));
                villager.setVillagerLevel(1);
                villager.setVillagerExperience(1);
                villager.setVillagerType(LazarusVariants.VILLAGER_TYPES.get(TARDISConstants.RANDOM.nextInt(LazarusVariants.VILLAGER_TYPES.size())));
                if (this.plugin.getPlanetsConfig().getBoolean("planets.gallifrey.villager_blueprints.enabled") && TARDISConstants.RANDOM.nextInt(100) < this.plugin.getPlanetsConfig().getInt("planets.gallifrey.villager_blueprints.chance")) {
                    villager.getPersistentDataContainer().set(this.plugin.getBlueprintKey(), PersistentDataType.BOOLEAN, (Object)true);
                    new GallifreyBlueprintTrade(this.plugin).setTrades((Merchant)villager);
                }
            }, 2L);
        }
    }
}

