/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateDestinationTerminalForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final List<String> worlds;

    public FloodgateDestinationTerminalForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.worlds = this.plugin.getTardisAPI().getWorlds();
    }

    public void send() {
        CustomForm form = (CustomForm)((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().title("Destination Terminal")).slider("X", -300.0f, 300.0f, 25.0f, 0.0f).slider("Z", -300.0f, 300.0f, 25.0f, 0.0f).slider("Multiplier", 1.0f, 4.0f, 1.0f).dropdown("World", this.worlds).toggle("Submarine", false).toggle("Just check calculated destination", false).validResultHandler(this::handleResponse)).build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(CustomFormResponse response) {
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        String world = this.worlds.get(response.asDropdown(3));
        if (this.plugin.getConfig().getBoolean("travel.per_world_perms") && !TARDISPermission.hasPermission(player, "tardis.travel." + world)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_WORLD", world);
            return;
        }
        World w = this.plugin.getServer().getWorld(world);
        if (w != null) {
            World.Environment e = w.getEnvironment();
            if (e.equals((Object)World.Environment.NETHER) && !this.plugin.getConfig().getBoolean("travel.nether")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_DISABLED", "Nether");
                return;
            }
            if (e.equals((Object)World.Environment.THE_END) && !this.plugin.getConfig().getBoolean("travel.the_end")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_DISABLED", "The End");
                return;
            }
            int multiplier = (int)response.asSlider(2);
            int x = (int)response.asSlider(0) * multiplier;
            int z = (int)response.asSlider(1) * multiplier;
            TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", this.uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
            if (rst.resultSet()) {
                int id = rst.getTardis_id();
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (rsc.resultSet()) {
                    Current current = rsc.getCurrent();
                    Location location = null;
                    switch (e) {
                        case THE_END: {
                            int endy = TARDISStaticLocationGetters.getHighestYin3x3(w, x, z);
                            if (endy > 40 && Math.abs(x) > 9 && Math.abs(z) > 9) {
                                Location loc = new Location(w, (double)x, 0.0, (double)z);
                                int[] estart = TARDISTimeTravel.getStartLocation(loc, current.direction());
                                int esafe = TARDISTimeTravel.safeLocation(estart[0], endy, estart[2], estart[1], estart[3], w, current.direction());
                                if (esafe == 0) {
                                    loc.setY((double)endy);
                                    if (this.plugin.getPluginRespect().getRespect(loc, new Parameters(player, Flag.getNoMessageFlags()))) {
                                        location = loc;
                                        this.plugin.getMessenger().sendStatus(player, "LOC_SET");
                                        break;
                                    }
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PROTECTED");
                                    break;
                                }
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                                break;
                            }
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                            break;
                        }
                        case NETHER: {
                            if (tt.safeNether(w, x, z, current.direction(), player)) {
                                location = new Location(w, (double)x, (double)this.plugin.getUtils().getHighestNetherBlock(w, x, z), (double)z);
                                this.plugin.getMessenger().sendStatus(player, "LOC_SET");
                                break;
                            }
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                            break;
                        }
                        default: {
                            int safe;
                            Location loc = new Location(w, (double)x, 0.0, (double)z);
                            int[] start = TARDISTimeTravel.getStartLocation(loc, current.direction());
                            int starty = TARDISStaticLocationGetters.getHighestYin3x3(w, x, z);
                            if (starty <= 0) {
                                starty = 1;
                            }
                            loc.setY((double)starty);
                            if (response.asToggle(4) && TARDISStaticUtils.isOceanBiome(loc.getBlock().getBiome())) {
                                Location subloc = tt.submarine(loc.getBlock(), current.direction());
                                if (subloc != null) {
                                    safe = 0;
                                    starty = subloc.getBlockY();
                                } else {
                                    safe = 1;
                                }
                            } else {
                                safe = TARDISTimeTravel.safeLocation(start[0], starty, start[2], start[1], start[3], w, current.direction());
                            }
                            if (safe == 0) {
                                Location over = new Location(w, (double)x, (double)starty, (double)z);
                                if (this.plugin.getPluginRespect().getRespect(over, new Parameters(player, Flag.getNoMessageFlags()))) {
                                    location = over;
                                    this.plugin.getMessenger().sendStatus(player, "LOC_SET");
                                    break;
                                }
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PROTECTED");
                                break;
                            }
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                        }
                    }
                    if (!response.asToggle(5) && location != null) {
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("world", location.getWorld().toString());
                        set.put("x", location.getBlockX());
                        set.put("y", location.getBlockY());
                        set.put("z", location.getBlockZ());
                        set.put("direction", (Object)current.direction());
                        set.put("submarine", response.asToggle(4) ? 1 : 0);
                        HashMap<String, Object> wheretid = new HashMap<String, Object>();
                        wheretid.put("tardis_id", id);
                        this.plugin.getQueryFactory().doSyncUpdate("next", set, wheretid);
                        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.TERMINAL));
                        this.plugin.getTrackerKeeper().getRescue().remove(id);
                        this.plugin.getMessenger().send(player, "DEST_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                            new TARDISLand(this.plugin, id, player).exitVortex();
                            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.TERMINAL, id));
                        }
                        DamageUtility.run(this.plugin, DiskCircuit.INPUT, id, player);
                    }
                } else {
                    new EmergencyRelocation(this.plugin).relocate(id, player);
                }
            }
        }
    }
}

