/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.ARSInventory;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.tardis.DirectionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.HideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RebuildCommand;
import me.eccentric_nz.TARDIS.control.TARDISInfoMenuButton;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.control.TARDISRandomButton;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.control.TARDISThemeButton;
import me.eccentric_nz.TARDIS.control.actions.FastReturnAction;
import me.eccentric_nz.TARDIS.control.actions.LightSwitchAction;
import me.eccentric_nz.TARDIS.control.actions.SiegeAction;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateAddCompanionsForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateAreasForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateChameleonCircuitForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateCompanionsForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateDesktopThemeForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateDestinationTerminalForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateMapForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgatePlayerPrefsForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateSavesForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateSystemUpgradesForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateTemporalForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateTransmatForm;
import me.eccentric_nz.TARDIS.move.BlackWoolToggler;
import me.eccentric_nz.TARDIS.rooms.ExteriorRenderer;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateControlForm {
    private final TARDIS plugin;
    private final UUID uuid;

    public FloodgateControlForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    public void send() {
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title("TARDIS Control Menu")).button("Random", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/random_button.png").button("Saves", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/saves_button.png").button("Back", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/back_button.png").button("Areas", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/areas_button.png").button("Terminal", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/dest_terminal.png").button("ARS", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/ars_button.png").button("Desktop Theme", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/theme_button.png").button("Power", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/power_on.png").button("Light switch", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/on_switch.png").button("Door toggle", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/toggle_open.png").button("Map", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/map_button.png").button("Chameleon Circuit", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/chameleon_button.png").button("Siege Mode", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/siege_on.png").button("Hide", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/hide_button.png").button("Rebuild", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/rebuild_button.png").button("Direction", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/direction_button.png").button("Temporal Locator", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/temporal_button.png").button("Artron Energy Levels", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/artron_button.png").button("Scanner", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/scan_button.png").button("TARDIS Information System", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/info_button.png").button("Transmat", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/transmat_button.png").button("Zero Room", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/zero_button.png").button("Player Preferences", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/prefs_button.png").button("Companions", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/companions_button.png").button("System Upgrades", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/system_upgrades_button.png").validResultHandler(this::handleResponse)).build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        int buttonId = response.clickedButtonId();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", this.uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                if (!tardis.isTardisInit()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
                    return;
                }
                if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn() && buttonId != 7 && buttonId != 12 && buttonId != 17) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                    return;
                }
                if (!tardis.isHandbrakeOn()) {
                    switch (buttonId) {
                        case 5: {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_NO_TRAVEL");
                            return;
                        }
                        case 6: 
                        case 7: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 18: {
                            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) break;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                            return;
                        }
                    }
                }
                boolean lights = tardis.isLightsOn();
                int level = tardis.getArtronLevel();
                CircuitChecker tcc = null;
                if (this.plugin.getConfig().getBoolean("difficulty.circuits")) {
                    tcc = new CircuitChecker(this.plugin, id);
                    tcc.getCircuits();
                }
                switch (buttonId) {
                    case 0: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
                            return;
                        }
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISRandomButton(this.plugin, player, id, level, 0, tardis.getCompanions(), tardis.getUuid()).clickButton(), 2L);
                        break;
                    }
                    case 1: {
                        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(this.uuid.toString(), SystemTree.SAVES)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                            return;
                        }
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (tcc != null && !tcc.hasMemory()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                            return;
                        }
                        new FloodgateSavesForm(this.plugin, this.uuid, id).send();
                        break;
                    }
                    case 2: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
                            return;
                        }
                        new FastReturnAction(this.plugin).clickButton(player, id, tardis);
                        break;
                    }
                    case 3: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (tcc != null && !tcc.hasMemory()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                            return;
                        }
                        new FloodgateAreasForm(this.plugin, this.uuid).send();
                        break;
                    }
                    case 4: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (level < this.plugin.getArtronConfig().getInt("travel")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                            return;
                        }
                        if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
                            return;
                        }
                        new FloodgateDestinationTerminalForm(this.plugin, this.uuid).send();
                        break;
                    }
                    case 5: {
                        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(this.uuid.toString(), SystemTree.ROOM_GROWING)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Room Growing");
                            return;
                        }
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (!this.plugin.getUtils().canGrowRooms(tardis.getChunk())) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_OWN_WORLD");
                            return;
                        }
                        if (!TARDISPermission.hasPermission(player, "tardis.architectural")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_ROOMS");
                            return;
                        }
                        if (tcc != null && !tcc.hasARS() && !this.plugin.getUtils().inGracePeriod(player, true)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_MISSING");
                            return;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_USE_CMD");
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new ARSInventory(this.plugin, player).getInventory()), 100L);
                        break;
                    }
                    case 6: {
                        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(this.uuid.toString(), SystemTree.DESKTOP_THEME)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Desktop Theme");
                            return;
                        }
                        int p_tid = TARDISThemeButton.getTardisId(this.uuid.toString());
                        if (p_tid != id) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPGRADE_OWN");
                            return;
                        }
                        if (this.plugin.getTrackerKeeper().getIsGrowingRooms().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_UPGRADE_WHILE_GROWING");
                            return;
                        }
                        UpgradeData tud = new UpgradeData();
                        tud.setPrevious(tardis.getSchematic());
                        tud.setLevel(level);
                        this.plugin.getTrackerKeeper().getUpgrades().put(this.uuid, tud);
                        new FloodgateDesktopThemeForm(this.plugin, this.uuid).send();
                        break;
                    }
                    case 7: {
                        if (this.plugin.getConfig().getBoolean("allow.power_down")) {
                            new TARDISPowerButton(this.plugin, id, player, tardis.getPreset(), tardis.isPoweredOn(), tardis.isHidden(), lights, player.getLocation(), level, tardis.getSchematic().getLights()).clickButton();
                            break;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN_DISABLED");
                        break;
                    }
                    case 8: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (!lights && this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                            return;
                        }
                        new LightSwitchAction(this.plugin, id, lights, player, tardis.getSchematic().getLights()).flickSwitch();
                        break;
                    }
                    case 9: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        new BlackWoolToggler(this.plugin).toggleBlocks(id, player);
                        break;
                    }
                    case 10: {
                        new FloodgateMapForm(this.plugin, this.uuid, id).send();
                        break;
                    }
                    case 11: {
                        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(this.uuid.toString(), SystemTree.CHAMELEON_CIRCUIT)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Chameleon Circuit");
                            return;
                        }
                        if (tcc != null && !tcc.hasChameleon()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_MISSING");
                            return;
                        }
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                            return;
                        }
                        new FloodgateChameleonCircuitForm(this.plugin, this.uuid, id, tardis.getPreset()).send();
                        break;
                    }
                    case 12: {
                        new SiegeAction(this.plugin).clickButton(tcc, player, tardis.isPoweredOn(), id);
                        break;
                    }
                    case 13: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        new HideCommand(this.plugin).hide((OfflinePlayer)player);
                        break;
                    }
                    case 14: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        new RebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)player);
                        break;
                    }
                    case 15: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        String direction = "EAST";
                        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                        if (rsc.resultSet()) {
                            int ordinal;
                            Current current = rsc.getCurrent();
                            direction = current.direction().toString();
                            if (!tardis.getPreset().usesArmourStand()) {
                                switch (current.direction()) {
                                    case SOUTH: {
                                        direction = "SOUTH_WEST";
                                        break;
                                    }
                                    case EAST: {
                                        direction = "SOUTH_EAST";
                                        break;
                                    }
                                    case NORTH: {
                                        direction = "NORTH_EAST";
                                        break;
                                    }
                                    case WEST: {
                                        direction = "NORTH_WEST";
                                        break;
                                    }
                                }
                            }
                            if ((ordinal = COMPASS.valueOf(direction).ordinal() + 1) == 8) {
                                ordinal = 0;
                            }
                            direction = COMPASS.values()[ordinal].toString();
                        }
                        String[] args = new String[]{"direction", direction};
                        new DirectionCommand(this.plugin).changeDirection(player, args);
                        break;
                    }
                    case 16: {
                        if (!TARDISPermission.hasPermission(player, "tardis.temporal")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_TEMPORAL");
                            return;
                        }
                        if (tcc != null && !tcc.hasTemporal() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TEMP_MISSING");
                            return;
                        }
                        new FloodgateTemporalForm(this.plugin, this.uuid).send();
                        break;
                    }
                    case 17: {
                        this.plugin.getMessenger().sendArtron(player, id, 0);
                        break;
                    }
                    case 18: {
                        new TARDISScanner(this.plugin).scan(id, player, tardis.getRenderer(), level);
                        break;
                    }
                    case 19: {
                        new TARDISInfoMenuButton(this.plugin, player).clickButton();
                        break;
                    }
                    case 20: {
                        new FloodgateTransmatForm(this.plugin, this.uuid, id).send();
                        break;
                    }
                    case 21: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        int zero_amount = this.plugin.getArtronConfig().getInt("zero");
                        if (level < zero_amount) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ZERO_ENERGY");
                            return;
                        }
                        Location zero = TARDISStaticLocationGetters.getLocationFromDB(tardis.getZero());
                        if (zero != null) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ZERO_READY");
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new ExteriorRenderer(this.plugin).transmat(player, COMPASS.SOUTH, zero), 20L);
                            this.plugin.getTrackerKeeper().getZeroRoomOccupants().add(player.getUniqueId());
                            HashMap<String, Object> wherez = new HashMap<String, Object>();
                            wherez.put("tardis_id", id);
                            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -zero_amount, wherez, player);
                            break;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_ZERO");
                        break;
                    }
                    case 22: {
                        new FloodgatePlayerPrefsForm(this.plugin, this.uuid).send();
                        break;
                    }
                    case 23: {
                        String comps = tardis.getCompanions();
                        if (comps == null || comps.isEmpty()) {
                            new FloodgateAddCompanionsForm(this.plugin, this.uuid).send();
                            return;
                        }
                        String[] companionData = comps.split(":");
                        new FloodgateCompanionsForm(this.plugin, this.uuid, companionData).send();
                        break;
                    }
                    case 24: {
                        if (!this.plugin.getConfig().getBoolean("difficulty.system_upgrades")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_DISABLED");
                            return;
                        }
                        new FloodgateSystemUpgradesForm(this.plugin, this.uuid, id).send();
                        break;
                    }
                }
            }
        }
    }
}

