/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.floodgate.FloodgateColouredBlocks;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateAreasForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Player player;
    private final String path = "textures/blocks/%s.png";

    public FloodgateAreasForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.player = this.plugin.getServer().getPlayer(this.uuid);
    }

    public void send() {
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, true, false);
        if (rsa.resultSet()) {
            SimpleForm.Builder builder = SimpleForm.builder();
            builder.title("TARDIS Areas");
            int i = 0;
            for (Area a : rsa.getData()) {
                String name = a.areaName();
                if (!TARDISPermission.hasPermission(this.player, "tardis.area." + name) && !TARDISPermission.hasPermission(this.player, "tardis.area.*")) continue;
                builder.button(name, FormImage.Type.PATH, String.format("textures/blocks/%s.png", FloodgateColouredBlocks.IMAGES.get(i)));
                ++i;
            }
            builder.validResultHandler(this::handleResponse);
            SimpleForm form = (SimpleForm)builder.build();
            FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
            player.sendForm((Form)form);
        } else {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "AREA_NONE");
        }
    }

    private void handleResponse(SimpleFormResponse response) {
        String label = response.clickedButton().text();
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("area_name", label);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
        rsa.resultSet();
        Location l = rsa.getArea().grid() ? this.plugin.getTardisArea().getNextSpot(label) : this.plugin.getTardisArea().getSemiRandomLocation(rsa.getArea().areaId());
        if (l == null) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_MORE_SPOTS");
            return;
        }
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", this.uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                new EmergencyRelocation(this.plugin).relocate(id, this.player);
                return;
            }
            Current current = rsc.getCurrent();
            if (this.plugin.getTardisArea().isInExistingArea(current.location(), rsa.getArea().areaId())) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "TRAVEL_NO_AREA");
                return;
            }
            HashMap<String, Object> set_next = new HashMap<String, Object>();
            set_next.put("world", l.getWorld().getName());
            set_next.put("x", l.getBlockX());
            set_next.put("y", l.getBlockY());
            set_next.put("z", l.getBlockZ());
            set_next.put("submarine", 0);
            if (!rsa.getArea().direction().isEmpty()) {
                set_next.put("direction", rsa.getArea().direction());
            } else {
                set_next.put("direction", current.direction().toString());
            }
            HashMap<String, Object> wheren = new HashMap<String, Object>();
            wheren.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("next", set_next, wheren);
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "TRAVEL_APPROVED", label);
            this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.AREA));
        }
    }
}

