/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardischunkgenerator.custombiome.BiomeUtilities;
import org.bukkit.command.CommandSender;

public class WorldNameConverter {
    private final HashMap<String, String> worldTables = new HashMap();
    private final HashMap<String, String> locationTables = new HashMap();
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String world;
    private final String legacy;
    private final String prefix;

    public WorldNameConverter(TARDIS plugin, String world) {
        this.plugin = plugin;
        this.world = world;
        this.legacy = BiomeUtilities.getLevelName() + "_tardis_" + world;
        this.prefix = this.plugin.getPrefix();
        this.worldTables.put("areas", "area_id");
        this.worldTables.put("back", "back_id");
        this.worldTables.put("current", "current_id");
        this.worldTables.put("destinations", "dest_id");
        this.worldTables.put("dispersed", "d_id");
        this.worldTables.put("homes", "home_id");
        this.worldTables.put("next", "next_id");
        this.locationTables.put("blocks", "b_id");
        this.locationTables.put("doors", "door_id");
        this.locationTables.put("forcefield", "uuid");
        this.locationTables.put("portals", "portal_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Statement statement = null;
        Statement ps = null;
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.createStatement();
            for (Map.Entry<String, String> entry : this.worldTables.entrySet()) {
                String worldQuery = "SELECT " + entry.getValue() + ", world FROM " + this.prefix + entry.getKey() + "tardis WHERE world LIKE '%" + this.world + "'";
                String worldUpdate = "UPDATE " + this.prefix + entry.getKey() + "SET world = '" + this.world + "' WHERE " + entry.getValue() + " = ?";
                ps = this.connection.prepareStatement(worldUpdate);
                this.connection.setAutoCommit(false);
                ResultSet rsw = statement.executeQuery(worldQuery);
                if (!rsw.isBeforeFirst()) continue;
                while (rsw.next()) {
                    ps.setInt(1, rsw.getInt(entry.getValue()));
                    ps.addBatch();
                    ++i;
                }
            }
            for (Map.Entry<String, String> entry : this.locationTables.entrySet()) {
                String locationQuery = "SELECT " + entry.getValue() + ", location FROM " + this.prefix + entry.getKey() + "tardis WHERE location LIKE '%" + this.world + "%'";
                String locationUpdate = "UPDATE " + this.prefix + entry.getKey() + "SET location = ? WHERE " + entry.getValue() + " = ?";
                ps = this.connection.prepareStatement(locationUpdate);
                this.connection.setAutoCommit(false);
                ResultSet rsl = statement.executeQuery(locationQuery);
                if (!rsl.isBeforeFirst()) continue;
                while (rsl.next()) {
                    String oldLocation = rsl.getString("location");
                    String newLocation = oldLocation.replace(this.legacy, this.world);
                    ps.setString(1, newLocation);
                    ps.setInt(2, rsl.getInt(entry.getValue()));
                    ps.addBatch();
                    ++i;
                }
            }
            if (i > 0) {
                ps.executeBatch();
                this.connection.commit();
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " old " + this.world + " world name records");
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for legacy world names! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tables (converting legacy world names)! " + e.getMessage());
            }
        }
    }
}

