/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.ARS.GrowSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISDisplayBlockRoomConverter
implements Runnable {
    private final TARDIS plugin;
    private final Player owner;
    private final int startX;
    private final int startY;
    private final int startZ;
    private final int c = 16;
    private final int h = 16;
    private final int w = 16;
    private boolean running;
    private int level = 0;
    private int row = 0;
    private int taskId;
    private World world;

    public TARDISDisplayBlockRoomConverter(TARDIS plugin, Player owner, GrowSlot slot) {
        this.plugin = plugin;
        this.owner = owner;
        this.startX = slot.getX();
        this.startY = slot.getY();
        this.startZ = slot.getZ();
    }

    @Override
    public void run() {
        if (!this.running) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", this.owner.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                this.world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            }
            this.running = true;
        }
        if (this.level == 15 && this.row == 15) {
            this.plugin.getServer().getScheduler().cancelTask(this.taskId);
            this.taskId = 0;
            this.plugin.getMessenger().message((CommandSender)this.owner, "Custom block display item conversion complete");
        } else {
            for (int col = 0; col < 16; ++col) {
                Component component;
                ItemMeta im;
                ItemStack is;
                ItemDisplay display;
                int x = this.startX + this.row;
                int y = this.startY + this.level;
                int z = this.startZ + col;
                Block block = this.world.getBlockAt(x, y, z);
                if (!this.isCustomBlock(block) || (display = TARDISDisplayItemUtils.getFromBoundingBox(block)) == null || (is = display.getItemStack()).getType().isAir() || !is.hasItemMeta() || !(im = is.getItemMeta()).hasDisplayName() || (component = im.displayName()) == null) continue;
                String name = ComponentUtils.toEnumUppercase(component);
                if (!component.children().isEmpty()) {
                    name = ComponentUtils.toEnumUppercase((Component)component.children().getFirst());
                }
                try {
                    TARDISDisplayItem tdi = TARDISDisplayItemRegistry.valueOf(name);
                    im.displayName((Component)ComponentUtils.toWhite(tdi.getDisplayName()));
                    if (name.toLowerCase(Locale.ROOT).contains("door")) {
                        im.setItemModel(tdi.getCustomModel());
                    } else {
                        im.setItemModel(null);
                    }
                    is.setItemMeta(im);
                    display.setItemStack(is);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.row < 16) {
                ++this.row;
            }
            if (this.row == 16 && this.level < 16) {
                this.row = 0;
                ++this.level;
            }
        }
    }

    private boolean isCustomBlock(Block block) {
        Material m = block.getType();
        if (m == Material.BARRIER || m == Material.LIGHT) {
            return true;
        }
        Interaction interaction = TARDISDisplayItemUtils.getInteraction(block);
        return interaction != null;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }
}

