/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIControlCentre;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoorBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.move.BlackWoolToggler;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class ControlInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final int id;
    private final Inventory inventory;

    public ControlInventory(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Control Menu", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getControls());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getControls() {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        String siege_onoff = "";
        String power_onoff = "";
        String direction = "";
        String off = this.plugin.getLanguage().getString("SET_OFF", "OFF");
        String on = this.plugin.getLanguage().getString("SET_ON", "ON");
        int delay = 1;
        boolean powered = true;
        boolean displayDoor = false;
        if (rs.resultSet()) {
            ResultSetPlayerPrefs rsp;
            Tardis tardis = rs.getTardis();
            siege_onoff = tardis.isSiegeOn() ? on : off;
            power_onoff = tardis.isPoweredOn() ? on : off;
            powered = tardis.isPoweredOn();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
            if (rsc.resultSet()) {
                direction = rsc.getCurrent().direction().toString();
            }
            if ((rsp = new ResultSetPlayerPrefs(this.plugin, tardis.getUuid().toString())).resultSet()) {
                delay = rsp.getThrottle();
                displayDoor = rsp.isOpenDisplayDoorOn();
            }
        }
        ItemStack ran = ItemStack.of((Material)GUIControlCentre.BUTTON_RANDOM.material(), (int)1);
        ItemMeta dom = ran.getItemMeta();
        dom.displayName((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"ran").decorate(TextDecoration.OBFUSCATED))).append(Component.text((String)this.plugin.getLanguage().getString("BUTTON_RANDOM", "Random Location")).decoration(TextDecoration.OBFUSCATED, false))).append(Component.text((String)"dom").decorate(TextDecoration.OBFUSCATED))).build());
        ran.setItemMeta(dom);
        ItemStack save = ItemStack.of((Material)GUIControlCentre.BUTTON_SAVES.material(), (int)1);
        ItemMeta locs = save.getItemMeta();
        locs.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SAVES", "Saved Locations")));
        locs.lore(List.of(Component.text((String)"load saves from this TARDIS")));
        save.setItemMeta(locs);
        ItemStack own = ItemStack.of((Material)GUIControlCentre.BUTTON_SAVES.material(), (int)1);
        ItemMeta saves = own.getItemMeta();
        saves.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SAVES", "Saved Locations")));
        saves.lore(List.of(Component.text((String)"Load my saves")));
        own.setItemMeta(saves);
        ItemStack fast = ItemStack.of((Material)GUIControlCentre.BUTTON_BACK.material(), (int)1);
        ItemMeta ret = fast.getItemMeta();
        ret.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_BACK", "Fast Return")));
        fast.setItemMeta(ret);
        ItemStack area = ItemStack.of((Material)GUIControlCentre.BUTTON_AREAS.material(), (int)1);
        ItemMeta tar = area.getItemMeta();
        tar.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_AREAS", "TARDIS Areas")));
        area.setItemMeta(tar);
        ItemStack ter = ItemStack.of((Material)GUIControlCentre.BUTTON_TERM.material(), (int)1);
        ItemMeta min = ter.getItemMeta();
        min.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_TERM", "Destination Terminal")));
        ter.setItemMeta(min);
        ItemStack thro = ItemStack.of((Material)GUIControlCentre.BUTTON_THROTTLE.material(), (int)1);
        ItemMeta ttle = thro.getItemMeta();
        ttle.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_THROTTLE", "Space Time Throttle")));
        String throttle = SpaceTimeThrottle.getByDelay().get(delay).toString();
        ttle.lore(List.of(Component.text((String)throttle)));
        thro.setItemMeta(ttle);
        ItemStack ars = ItemStack.of((Material)GUIControlCentre.BUTTON_ARS.material(), (int)1);
        ItemMeta but = ars.getItemMeta();
        but.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_ARS", "Architectural Reconfiguration System")));
        ars.setItemMeta(but);
        ItemStack upg = ItemStack.of((Material)GUIControlCentre.BUTTON_THEME.material(), (int)1);
        ItemMeta rade = upg.getItemMeta();
        rade.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_THEME", "Desktop Theme")));
        upg.setItemMeta(rade);
        ItemStack pow = ItemStack.of((Material)GUIControlCentre.BUTTON_POWER.material(), (int)1);
        ItemMeta dwn = pow.getItemMeta();
        dwn.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_POWER", "Power")));
        dwn.lore(List.of(Component.text((String)power_onoff)));
        CustomModelDataComponent pdcomponent = dwn.getCustomModelDataComponent();
        pdcomponent.setFloats(!powered ? SwitchVariant.BUTTON_POWER_OFF.getFloats() : SwitchVariant.BUTTON_POWER_ON.getFloats());
        dwn.setCustomModelDataComponent(pdcomponent);
        pow.setItemMeta(dwn);
        ItemStack lig = ItemStack.of((Material)GUIControlCentre.BUTTON_LIGHTS.material(), (int)1);
        ItemMeta swi = lig.getItemMeta();
        swi.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_LIGHTS", "Lights")));
        swi.lore(List.of(Component.text((String)"All the light things!")));
        lig.setItemMeta(swi);
        ItemStack tog = ItemStack.of((Material)GUIControlCentre.BUTTON_TOGGLE.material(), (int)1);
        ItemMeta gle = tog.getItemMeta();
        CustomModelDataComponent twcomponent = gle.getCustomModelDataComponent();
        if (displayDoor) {
            ResultSetDoorBlocks rsd = new ResultSetDoorBlocks(this.plugin, this.id);
            rsd.resultSet();
            boolean open = TARDISStaticUtils.isDoorOpen(rsd.getInnerBlock());
            gle.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_DOOR", "TARDIS door")));
            String currently = open ? this.plugin.getLanguage().getString("SET_OPEN", "OPEN") : this.plugin.getLanguage().getString("SET_CLOSED", "CLOSED");
            String clickTo = open ? "close" : "open";
            gle.lore(List.of(Component.text((String)("Currently " + currently)), Component.text((String)("Click to " + clickTo))));
            twcomponent.setFloats(!open ? SwitchVariant.DISPLAY_DOOR_CLOSED.getFloats() : SwitchVariant.DISPLAY_DOOR_OPEN.getFloats());
        } else {
            boolean open = new BlackWoolToggler(this.plugin).isOpen(this.id);
            gle.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_TOGGLE", "Toggle blocks behind door")));
            String toggle_openclosed = open ? this.plugin.getLanguage().getString("SET_OPEN", "OPEN") : this.plugin.getLanguage().getString("SET_CLOSED", "CLOSED");
            gle.lore(List.of(Component.text((String)toggle_openclosed)));
            twcomponent.setFloats(!open ? SwitchVariant.BUTTON_TOGGLE_OFF.getFloats() : SwitchVariant.BUTTON_TOGGLE_ON.getFloats());
        }
        gle.setCustomModelDataComponent(twcomponent);
        tog.setItemMeta(gle);
        ItemStack map = ItemStack.of((Material)Material.MAP, (int)1);
        ItemMeta me = map.getItemMeta();
        me.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_TARDIS_MAP", "TARDIS Map")));
        map.setItemMeta(me);
        ItemStack cham = ItemStack.of((Material)GUIControlCentre.BUTTON_CHAMELEON.material(), (int)1);
        ItemMeta eleon = cham.getItemMeta();
        eleon.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CHAMELEON", "Chameleon Circuit")));
        cham.setItemMeta(eleon);
        ItemStack siege = ItemStack.of((Material)GUIControlCentre.BUTTON_SIEGE.material(), (int)1);
        ItemMeta mode = siege.getItemMeta();
        mode.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SIEGE", "Siege Mode")));
        mode.lore(List.of(Component.text((String)siege_onoff)));
        CustomModelDataComponent smcomponent = mode.getCustomModelDataComponent();
        smcomponent.setFloats(siege_onoff.equals(off) ? SwitchVariant.SIEGE_OFF.getFloats() : SwitchVariant.SIEGE_ON.getFloats());
        mode.setCustomModelDataComponent(smcomponent);
        siege.setItemMeta(mode);
        ItemStack hide = ItemStack.of((Material)GUIControlCentre.BUTTON_HIDE.material(), (int)1);
        ItemMeta box = hide.getItemMeta();
        box.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_HIDE", "Hide")));
        hide.setItemMeta(box);
        ItemStack reb = ItemStack.of((Material)GUIControlCentre.BUTTON_REBUILD.material(), (int)1);
        ItemMeta uild = reb.getItemMeta();
        uild.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_REBUILD", "Rebuild")));
        reb.setItemMeta(uild);
        ItemStack dir = ItemStack.of((Material)GUIControlCentre.BUTTON_DIRECTION.material(), (int)1);
        ItemMeta ection = dir.getItemMeta();
        ection.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_DIRECTION", "Direction")));
        ection.lore(List.of(Component.text((String)direction)));
        dir.setItemMeta(ection);
        ItemStack temp = ItemStack.of((Material)GUIControlCentre.BUTTON_TEMP.material(), (int)1);
        ItemMeta oral = temp.getItemMeta();
        oral.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_TEMP", "Temporal Locator")));
        temp.setItemMeta(oral);
        ItemStack art = ItemStack.of((Material)GUIControlCentre.BUTTON_ARTRON.material(), (int)1);
        ItemMeta ron = art.getItemMeta();
        ron.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_ARTRON", "Artron Energy Levels")));
        art.setItemMeta(ron);
        ItemStack scan = ItemStack.of((Material)GUIControlCentre.BUTTON_SCANNER.material(), (int)1);
        ItemMeta ner = scan.getItemMeta();
        ner.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCANNER", "Scanner")));
        scan.setItemMeta(ner);
        ItemStack info = ItemStack.of((Material)GUIControlCentre.BUTTON_INFO.material(), (int)1);
        ItemMeta sys = info.getItemMeta();
        sys.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_INFO", "TARDIS Information System")));
        info.setItemMeta(sys);
        ItemStack tran = ItemStack.of((Material)GUIControlCentre.BUTTON_TRANSMAT.material(), (int)1);
        ItemMeta smat = tran.getItemMeta();
        smat.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_TRANSMAT", "Transmat")));
        tran.setItemMeta(smat);
        ItemStack zero = ItemStack.of((Material)GUIControlCentre.BUTTON_ZERO.material(), (int)1);
        ItemMeta room = zero.getItemMeta();
        room.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_ZERO", "Zero Room transmat")));
        zero.setItemMeta(room);
        ItemStack player = ItemStack.of((Material)GUIControlCentre.BUTTON_PREFS.material(), (int)1);
        ItemMeta prefs = player.getItemMeta();
        prefs.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_PREFS", "Player Preferences")));
        player.setItemMeta(prefs);
        ItemStack companion = ItemStack.of((Material)GUIControlCentre.COMPANIONS_MENU.material(), (int)1);
        ItemMeta list = companion.getItemMeta();
        list.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("COMPANIONS_MENU", "Companion Menu")));
        companion.setItemMeta(list);
        ItemStack system = null;
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades")) {
            system = ItemStack.of((Material)GUIControlCentre.BUTTON_SYSTEM_UPGRADES.material(), (int)1);
            ItemMeta upgrades = system.getItemMeta();
            upgrades.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("SYS_MENU", "System Upgrades")));
            system.setItemMeta(upgrades);
        }
        ItemStack close = ItemStack.of((Material)GUIControlCentre.BUTTON_CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        return new ItemStack[]{ran, null, ars, null, cham, null, art, null, zero, save, null, upg, null, siege, null, scan, null, player, own, null, pow, null, hide, null, info, null, companion, fast, null, lig, null, reb, null, tran, null, system, area, null, tog, null, dir, null, null, null, null, ter, null, map, null, temp, null, thro, null, close};
    }
}

