/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConstructSign;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class ConstructCommand {
    private final TARDIS plugin;
    private final List<String> lineNumbers = List.of("1", "2", "3", "4");

    ConstructCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean setLine(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (!rs.fromUUID(player.getUniqueId().toString())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return true;
        }
        int id = rs.getTardisId();
        ResultSetConstructSign rscs = new ResultSetConstructSign(this.plugin, id);
        if (!rscs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_CONSTRUCT");
            return true;
        }
        if (!this.lineNumbers.contains(args[1])) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONSTRUCT_LINE_NUM");
            return true;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        HashMap<String, Object> set = new HashMap<String, Object>();
        int l = TARDISNumberParsers.parseInt(args[1]);
        TextComponent raw = LegacyComponentSerializer.legacyAmpersand().deserialize(String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)));
        if (ComponentUtils.stripColour((Component)raw).length() > 16) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONSTRUCT_LINE_LEN");
            return true;
        }
        set.put("line" + l, raw);
        this.plugin.getQueryFactory().doUpdate("chameleon", set, where);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONSTRUCT_LINE_SAVED");
        return true;
    }
}

