/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.shell;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.ShellBuilder;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chameleon.construct.ConstructBuilder;
import me.eccentric_nz.TARDIS.chameleon.shell.ShellInventory;
import me.eccentric_nz.TARDIS.chameleon.shell.ShellLoaderProblemBlocks;
import me.eccentric_nz.TARDIS.chameleon.shell.ShellRoomConstructor;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonColumn;
import me.eccentric_nz.TARDIS.commands.tardis.RebuildCommand;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetShells;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerShellListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> selected = new HashMap();

    public PlayerShellListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onShellLoaderClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ShellInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot < 0 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack is = view.getItem(slot);
        if (is == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (!rst.resultSet()) {
            return;
        }
        int id = rst.getTardis_id();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        ChameleonColumn chameleonColumn = null;
        Location button = this.getButton(id);
        if (button == null) {
            return;
        }
        switch (slot) {
            case 53: {
                this.close(player);
                break;
            }
            case 50: {
                new ShellRoomConstructor(this.plugin).createShell(player, id, button.getBlock(), -1);
                this.close(player);
                break;
            }
            case 49: {
                this.clear(button, false, id);
                this.close(player);
                break;
            }
            case 47: {
                if (this.selected.containsKey(uuid)) {
                    int cid = this.getChameleonId(view, this.selected.get(uuid));
                    new ShellRoomConstructor(this.plugin).createShell(player, id, button.getBlock(), cid);
                    this.close(player);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SHELL_SELECT");
                break;
            }
            case 46: {
                if (this.selected.containsKey(uuid)) {
                    if (this.isActive(view, this.selected.get(uuid))) {
                        HashMap<String, Object> setf = new HashMap<String, Object>();
                        setf.put("chameleon_preset", "FACTORY");
                        setf.put("adapti_on", 0);
                        HashMap<String, Object> wheref = new HashMap<String, Object>();
                        wheref.put("tardis_id", id);
                        this.plugin.getQueryFactory().doSyncUpdate("tardis", setf, wheref);
                        new RebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)player);
                    }
                    int cid = this.getChameleonId(view, this.selected.get(uuid));
                    HashMap<String, Object> whered = new HashMap<String, Object>();
                    whered.put("chameleon_id", cid);
                    this.plugin.getQueryFactory().doDelete("chameleon", whered);
                    this.close(player);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SHELL_SELECT");
                break;
            }
            case 45: {
                if (this.selected.containsKey(uuid)) {
                    int cid = this.getChameleonId(view, this.selected.get(uuid));
                    if (cid == -1) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SHELL_SELECT");
                        return;
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        HashMap<String, Object> seti = new HashMap<String, Object>();
                        seti.put("active", 0);
                        HashMap<String, Object> wherei = new HashMap<String, Object>();
                        wherei.put("tardis_id", id);
                        this.plugin.getQueryFactory().doSyncUpdate("chameleon", seti, wherei);
                    }, 1L);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        HashMap<String, Object> wheresc = new HashMap<String, Object>();
                        wheresc.put("chameleon_id", cid);
                        HashMap<String, Object> seta = new HashMap<String, Object>();
                        seta.put("active", 1);
                        this.plugin.getQueryFactory().doSyncUpdate("chameleon", seta, wheresc);
                    }, 5L);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new ConstructBuilder(this.plugin).build(rs.getTardis().getPreset().toString(), id, player), 10L);
                    this.close(player);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SHELL_SELECT");
                break;
            }
            default: {
                String data;
                int cid = this.getChameleonId(view, slot);
                if (cid == -1) {
                    return;
                }
                this.selected.put(uuid, slot);
                ChameleonPreset preset = ChameleonPreset.CONSTRUCT;
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("chameleon_id", cid);
                ResultSetShells rsc = new ResultSetShells(this.plugin, wherec);
                if (rsc.resultSet() && (data = rsc.getData().getFirst().get("blueprintData")) != null) {
                    JsonArray json = JsonParser.parseString((String)data).getAsJsonArray();
                    String[][] strings = new String[10][4];
                    for (int i = 0; i < 10; ++i) {
                        JsonArray inner = json.get(i).getAsJsonArray();
                        for (int j = 0; j < 4; ++j) {
                            String block;
                            strings[i][j] = block = inner.get(j).getAsString();
                        }
                    }
                    chameleonColumn = TARDISChameleonPreset.buildTARDISChameleonColumn(COMPASS.EAST, strings);
                }
                if (chameleonColumn == null) {
                    return;
                }
                this.clear(button, true, id);
                Location centre = button.clone().add(3.0, 1.0, 0.0);
                new ShellBuilder(this.plugin, preset, chameleonColumn, centre, cid).buildPreset();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onShellBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            Block b = event.getBlock();
            String l = b.getLocation().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("location", l);
            where.put("police_box", 3);
            ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, where, false);
            if (rsb.resultSet()) {
                this.plugin.getMessenger().sendStatus(player, "SHELL_CLEAR");
                event.setCancelled(true);
            }
        }
    }

    private int getChameleonId(InventoryView view, int slot) {
        ItemStack shell = view.getItem(slot);
        ItemMeta im = shell.getItemMeta();
        PersistentDataContainer pdc = im.getPersistentDataContainer();
        if (!pdc.has(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER)) {
            return -1;
        }
        return (Integer)pdc.get(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER);
    }

    private boolean isActive(InventoryView view, int slot) {
        ItemStack shell = view.getItem(slot);
        ItemMeta im = shell.getItemMeta();
        return im.hasLore() && im.lore().size() > 4;
    }

    private Location getButton(int id) {
        HashMap<String, Object> whereb = new HashMap<String, Object>();
        whereb.put("tardis_id", id);
        whereb.put("type", 25);
        ResultSetControls resultSetControls = new ResultSetControls(this.plugin, whereb, false);
        if (!resultSetControls.resultSet()) {
            return null;
        }
        return TARDISStaticLocationGetters.getLocationFromBukkitString(resultSetControls.getLocation());
    }

    private void clear(Location button, boolean protect, int id) {
        int y;
        int c;
        World w = button.getWorld();
        int fx = button.getBlockX() + 2;
        int fy = button.getBlockY() + 1;
        int fz = button.getBlockZ() - 1;
        for (c = 0; c < 10; ++c) {
            for (y = fy; y < fy + 4; ++y) {
                Block block = w.getBlockAt(fx + ShellRoomConstructor.orderx[c], y, fz + ShellRoomConstructor.orderz[c]);
                if (!ShellLoaderProblemBlocks.DO_FIRST.contains(block.getType())) continue;
                block.setBlockData(TARDISConstants.AIR);
            }
        }
        for (c = 0; c < 10; ++c) {
            for (y = fy; y < fy + 4; ++y) {
                Block b = w.getBlockAt(fx + ShellRoomConstructor.orderx[c], y, fz + ShellRoomConstructor.orderz[c]);
                b.setBlockData(TARDISConstants.AIR);
                String loc = b.getLocation().toString();
                if (protect) {
                    HashMap<String, Object> setpb = new HashMap<String, Object>();
                    setpb.put("tardis_id", id);
                    setpb.put("location", loc);
                    setpb.put("data", "minecraft:air");
                    setpb.put("police_box", 3);
                    this.plugin.getQueryFactory().doInsert("blocks", setpb);
                    this.plugin.getGeneralKeeper().getProtectBlockMap().put(loc, id);
                    continue;
                }
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                wherep.put("tardis_id", id);
                wherep.put("police_box", 3);
                this.plugin.getQueryFactory().doDelete("blocks", wherep);
                this.plugin.getGeneralKeeper().getProtectBlockMap().remove(loc);
            }
        }
    }
}

