/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron.actions;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.artron.ArtronAbandoned;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ArtronInitAction {
    private final TARDIS plugin;

    public ArtronInitAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void powerUp(Location location, Tardis tardis, Player player, int id) {
        String creeper;
        TARDISSounds.playTARDISSound(location, "power_up");
        if (tardis.isAbandoned()) {
            new ArtronAbandoned(this.plugin).claim(player, id, location, tardis);
        }
        if (!(creeper = tardis.getCreeper()).isEmpty() && !creeper.equals(":")) {
            World w = location.getWorld();
            Location cl = TARDISStaticLocationGetters.getLocationFromDB(creeper);
            this.plugin.setTardisSpawn(true);
            Entity e = w.spawnEntity(cl.add(0.0, 1.0, 0.0), EntityType.CREEPER);
            Creeper c = (Creeper)e;
            c.setPowered(true);
            c.setRemoveWhenFarAway(false);
            if (tardis.getSchematic().hasBeacon()) {
                String beacon = tardis.getBeacon();
                Block bl = TARDISStaticLocationGetters.getLocationFromDB(beacon).getBlock();
                bl.setBlockData(TARDISConstants.GLASS);
            }
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        int half = Math.round((float)this.plugin.getArtronConfig().getInt("full_charge") / 2.0f);
        set.put("artron_level", half);
        set.put("tardis_init", 1);
        set.put("powered_on", 1);
        HashMap<String, Object> whereid = new HashMap<String, Object>();
        whereid.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("tardis", set, whereid);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_INIT");
    }
}

