/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.SerializeInventory;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.enumeration.Storage;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class AreaDisks {
    private final TARDIS plugin;

    AreaDisks(TARDIS plugin) {
        this.plugin = plugin;
    }

    ItemStack[] makeDisks(Player p) {
        ArrayList areas = new ArrayList();
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, false, false);
        if (rsa.resultSet()) {
            rsa.getData().forEach(a -> {
                String name = a.areaName();
                if (TARDISPermission.hasPermission(p, "tardis.area." + name) || TARDISPermission.hasPermission(p, "tardis.area.*")) {
                    ItemStack is = ItemStack.of((Material)Material.MUSIC_DISC_BLOCKS, (int)1);
                    ItemMeta im = is.getItemMeta();
                    im.displayName((Component)Component.text((String)"Area Storage Disk"));
                    im.lore(List.of(Component.text((String)name), Component.text((String)a.world())));
                    im.addItemFlags(ItemFlag.values());
                    im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                    is.setItemMeta(im);
                    areas.add(is);
                }
            });
        }
        ItemStack[] stack = new ItemStack[54];
        try {
            stack = SerializeInventory.itemStacksFromString(Storage.AREA.getEmpty());
        }
        catch (IOException ex) {
            this.plugin.debug("Could not get make Area Disk Inventory: " + String.valueOf(ex));
        }
        int i = 27;
        Iterator iterator = areas.iterator();
        while (iterator.hasNext()) {
            ItemStack st;
            stack[i] = st = (ItemStack)iterator.next();
            ++i;
        }
        return stack;
    }

    String checkDisksForNewAreas(Player p) {
        String serialized = "";
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", p.getUniqueId().toString());
        ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
        if (rs.resultSet()) {
            ArrayList<String> player_has = new ArrayList<String>();
            String serialized_areas = rs.getAreas();
            try {
                ItemStack[] player;
                ItemStack[] console;
                ItemStack[] areas;
                for (ItemStack a : areas = SerializeInventory.itemStacksFromString(serialized_areas)) {
                    ItemMeta ima;
                    if (a == null || !a.getType().equals((Object)Material.MUSIC_DISC_BLOCKS) || !a.hasItemMeta() || !(ima = a.getItemMeta()).hasLore()) continue;
                    player_has.add(ComponentUtils.stripColour((Component)ima.lore().getFirst()));
                }
                for (ItemStack c : console = SerializeInventory.itemStacksFromString(rs.getConsole())) {
                    ItemMeta imc;
                    if (c == null || !c.getType().equals((Object)Material.MUSIC_DISC_BLOCKS) || !c.hasItemMeta() || !(imc = c.getItemMeta()).hasLore()) continue;
                    player_has.add(ComponentUtils.stripColour((Component)imc.lore().getFirst()));
                }
                for (ItemStack y : player = p.getInventory().getContents()) {
                    ItemMeta imy;
                    if (y == null || !y.getType().equals((Object)Material.MUSIC_DISC_BLOCKS) || !y.hasItemMeta() || !(imy = y.getItemMeta()).hasLore()) continue;
                    player_has.add(ComponentUtils.stripColour((Component)imy.lore().getFirst()));
                }
                Inventory inv = this.plugin.getServer().createInventory((InventoryHolder)p, 54);
                inv.setContents(areas);
                ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, true, false);
                int count = 0;
                if (rsa.resultSet()) {
                    for (Area map : rsa.getData()) {
                        int empty;
                        String name = map.areaName();
                        if ((player_has.contains(name) || !TARDISPermission.hasPermission(p, "tardis.area." + name)) && (player_has.contains(name) || !TARDISPermission.hasPermission(p, "tardis.area.*")) || (empty = this.getNextEmptySlot(inv)) == -1) continue;
                        ItemStack is = ItemStack.of((Material)Material.MUSIC_DISC_BLOCKS, (int)1);
                        ItemMeta im = is.getItemMeta();
                        im.displayName((Component)Component.text((String)"Area Storage Disk"));
                        im.lore(List.of(Component.text((String)name), Component.text((String)map.world())));
                        im.addItemFlags(ItemFlag.values());
                        im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                        is.setItemMeta(im);
                        inv.setItem(empty, is);
                        ++count;
                    }
                }
                if (count > 0) {
                    return SerializeInventory.itemStacksToString(inv.getContents());
                }
                return serialized_areas;
            }
            catch (IOException ex) {
                this.plugin.debug("Could not get NEW Area Disk Inventory: " + String.valueOf(ex));
            }
        }
        return serialized;
    }

    int getNextEmptySlot(Inventory inv) {
        for (int i = 27; i < 54; ++i) {
            if (inv.getItem(i) != null && !inv.getItem(i).getType().isAir()) continue;
            return i;
        }
        return -1;
    }
}

