/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.artron.ArtronFurnaceParticle;
import me.eccentric_nz.TARDIS.artron.ArtronPoweredRunnable;
import me.eccentric_nz.TARDIS.artron.StandbyMode;
import me.eccentric_nz.TARDIS.console.ControlMonitor;
import me.eccentric_nz.TARDIS.control.ControlRunnable;
import me.eccentric_nz.TARDIS.desktop.DesktopPreview;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.forcefield.ForceField;
import me.eccentric_nz.TARDIS.handles.HandlesRunnable;
import me.eccentric_nz.TARDIS.junk.JunkReturnRunnable;
import me.eccentric_nz.TARDIS.move.SpectaclesRunnable;
import me.eccentric_nz.TARDIS.move.TARDISMonsterRunnable;
import me.eccentric_nz.TARDIS.rooms.ZeroRoomRunnable;
import me.eccentric_nz.TARDIS.siegemode.SiegeRunnable;
import me.eccentric_nz.TARDIS.utility.HumSounds;
import me.eccentric_nz.TARDIS.utility.VaultChecker;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISRunnables {
    private final TARDIS plugin;

    public TARDISRunnables(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static void startStandBy(TARDIS plugin) {
        if (plugin.getConfig().getBoolean("allow.power_down")) {
            long repeat = plugin.getArtronConfig().getLong("standby_time");
            if (repeat <= 0L) {
                return;
            }
            plugin.setStandbyTask(plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)new StandbyMode(plugin), 6000L, repeat));
        }
    }

    public void start() {
        if (this.plugin.getArtronConfig().getBoolean("artron_furnace.particles")) {
            new ArtronFurnaceParticle(this.plugin).addParticles();
        }
        if (this.plugin.getArtronConfig().getBoolean("artron_furnace.tardis_powered")) {
            long cycle = this.plugin.getArtronConfig().getLong("artron_furnace.power_cycle");
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new ArtronPoweredRunnable(this.plugin), cycle, cycle);
        }
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> new HumSounds().playTARDISHum(), 60L, 1500L);
        if (this.plugin.getHandlesConfig().getBoolean("reminders.enabled")) {
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new HandlesRunnable(this.plugin), 120L, this.plugin.getHandlesConfig().getLong("reminders.schedule"));
        }
        if (this.plugin.getConfig().getBoolean("siege.enabled")) {
            long ticks = this.plugin.getArtronConfig().getLong("siege_ticks");
            if (ticks <= 0L) {
                return;
            }
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new SiegeRunnable(this.plugin), 1500L, ticks);
        }
        if (this.plugin.getConfig().getBoolean("allow.zero_room")) {
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new ZeroRoomRunnable(this.plugin), 20L, this.plugin.getConfig().getLong("preferences.heal_speed"));
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new VaultChecker(this.plugin), 2400L);
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TARDISMonsterRunnable(this.plugin), 2400L, 2400L);
        if (this.plugin.getConfig().getBoolean("allow.3d_doors")) {
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new SpectaclesRunnable(this.plugin), 120L, 100L);
        }
        if (this.plugin.getConfig().getInt("allow.force_field") > 0) {
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new ForceField(this.plugin), 20L, 5L);
        }
        if (this.plugin.getConfig().getBoolean("junk.enabled") && this.plugin.getConfig().getLong("junk.return") > 0L) {
            long delay = this.plugin.getConfig().getLong("junk.return") * 20L;
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new JunkReturnRunnable(this.plugin), delay, delay);
        }
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new ControlRunnable(this.plugin), 200L, 200L);
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new ControlMonitor(this.plugin), 300L, 200L);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (!TARDISAchievementFactory.checkAdvancement("tardis")) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, this.plugin.getLanguage().getString("ADVANCEMENT_RELOAD"));
            }
        }, 199L);
        if (this.plugin.getConfig().getBoolean("allow.power_down")) {
            long repeat = this.plugin.getArtronConfig().getLong("standby_time");
            if (repeat <= 0L) {
                return;
            }
            TARDISRunnables.startStandBy(this.plugin);
        }
        if (this.plugin.getConfig().getBoolean("desktop.previews") && this.plugin.getConfig().getBoolean("creation.default_world")) {
            new DesktopPreview(this.plugin).create();
        }
    }
}

