/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.populators;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.schematic.setters.ArmourStandSetter;
import me.eccentric_nz.tardischunkgenerator.worldgen.populators.IslandBlockPopulator;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.TARDISLootTables;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;

public class TelosStructurePopulator
extends BlockPopulator {
    private final TARDIS plugin;
    private final IslandBlockPopulator.WeightedChoice<Material> STONES = new IslandBlockPopulator.WeightedChoice<Material>().add(70.0, Material.STONE).add(10.0, Material.ANDESITE).add(10.0, Material.DIORITE).add(10.0, Material.GRANITE).add(5.0, Material.COAL_ORE);

    public TelosStructurePopulator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void populate(WorldInfo worldInfo, Random random, int x, int z, LimitedRegion limitedRegion) {
        int zz;
        int y;
        int xx;
        if (this.isFeatureChunk(worldInfo.getSeed(), x, z) && limitedRegion.isInRegion(xx = x * 16, y = 24 + TARDISConstants.RANDOM.nextInt(20), zz = z * 16) && limitedRegion.getBuffer() > 15) {
            this.build(limitedRegion, xx, y, zz, random);
        }
    }

    public boolean isFeatureChunk(long seed, int x, int z) {
        RandomSpreadStructurePlacement spread = new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.TRIANGULAR, 165745295);
        ChunkPos chunkPos = spread.getPotentialStructureChunk(seed, x, z);
        return chunkPos.x == x && chunkPos.z == z;
    }

    private void build(LimitedRegion limitedRegion, int startX, int startY, int startZ, Random random) {
        String path = "schematics/cryo_chamber.tschm";
        InputStream stream = this.plugin.getResource(path);
        if (stream != null) {
            JsonObject obj = SchematicGZip.unzip(stream);
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int h = dimensions.get("height").getAsInt() - 1;
            int w = dimensions.get("width").getAsInt();
            int d = dimensions.get("length").getAsInt() - 1;
            int level = 0;
            int row = 0;
            JsonArray arr = obj.get("input").getAsJsonArray();
            while (level <= h && row < w) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                JsonArray r = floor.get(row).getAsJsonArray();
                for (int col = 0; col <= d; ++col) {
                    JsonObject c = r.get(col).getAsJsonObject();
                    int x = startX + row;
                    int y = startY + level;
                    int z = startZ + col;
                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                    Material type = data.getMaterial();
                    if (limitedRegion.isInRegion(x, y, z)) {
                        switch (type) {
                            case WAXED_OXIDIZED_COPPER_CHEST: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (!limitedRegion.getType(x, y, z).equals((Object)Material.WAXED_OXIDIZED_COPPER_CHEST)) break;
                                Chest container = (Chest)limitedRegion.getBlockState(x, y, z);
                                container.setLootTable(TARDISLootTables.LOOT.get(random.nextInt(11)));
                                container.update();
                                break;
                            }
                            case SPONGE: {
                                break;
                            }
                            case SOUL_SAND: {
                                limitedRegion.setType(x, y, z, Material.SPAWNER);
                                CreatureSpawner cs = (CreatureSpawner)limitedRegion.getBlockState(x, y, z);
                                cs.setSpawnedType(EntityType.ZOMBIE);
                                cs.update();
                                break;
                            }
                            case STONE: {
                                Material stone = this.STONES.next();
                                limitedRegion.setType(x, y, z, stone);
                                break;
                            }
                            default: {
                                limitedRegion.setBlockData(x, y, z, data);
                            }
                        }
                    }
                    if (col == d && row < w) {
                        ++row;
                    }
                    if (col != d || row != w || level >= h) continue;
                    row = 0;
                    ++level;
                }
            }
            if (obj.has("armour_stands")) {
                JsonArray stands = obj.get("armour_stands").getAsJsonArray();
                ArmourStandSetter.setStands(stands, limitedRegion.getWorld(), startX, startY, startZ);
            }
        }
    }
}

