/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility.protection;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class TARDISTownyChecker {
    private final Towny towny;
    private TownyRegion tr;

    public TARDISTownyChecker(TARDIS plugin) {
        this.towny = (Towny)plugin.getPM().getPlugin("Towny");
        try {
            this.tr = TownyRegion.valueOf(plugin.getConfig().getString("preferences.respect_towny"));
        }
        catch (IllegalArgumentException e) {
            plugin.debug("Could not get TownyRegion from config!");
            this.tr = TownyRegion.nation;
        }
    }

    public boolean playerHasPermission(Player player, Block block) {
        return PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.DESTROY);
    }

    public boolean checkTowny(Player p, Location l) {
        if (this.towny != null) {
            boolean bool = false;
            switch (this.tr.ordinal()) {
                case 0: {
                    bool = TownyAPI.getInstance().isWilderness(l.getBlock().getLocation());
                    break;
                }
                case 1: {
                    bool = this.playerIsResident(p, l).canTravel();
                    break;
                }
                case 2: {
                    bool = this.playerIsCompatriot(p, l);
                    break;
                }
            }
            return bool;
        }
        return false;
    }

    private TownyData playerIsResident(Player p, Location l) {
        TownyData td = new TownyData();
        TownBlock tb = TownyAPI.getInstance().getTownBlock(l);
        if (tb == null) {
            td.setCanTravel(true);
            return td;
        }
        td.setTownBlock(tb);
        Resident res = TownyUniverse.getInstance().getResident(p.getUniqueId());
        td.setResident(res);
        if (res != null) {
            try {
                if (res.getTown().equals((Object)tb.getTown())) {
                    td.setCanTravel(true);
                    return td;
                }
            }
            catch (NotRegisteredException ex) {
                td.setCanTravel(true);
                return td;
            }
        }
        td.setCanTravel(TownyAPI.getInstance().isWilderness(l.getBlock().getLocation()));
        return td;
    }

    private boolean playerIsCompatriot(Player p, Location l) {
        TownyData td = this.playerIsResident(p, l);
        if (td.canTravel()) {
            return true;
        }
        if (td.getResident().hasNation() && td.getResident().hasTown()) {
            try {
                Nation nation = td.getResident().getTown().getNation();
                if (td.getTownBlock().hasTown() && td.getTownBlock().getTown().getNation().equals((Object)nation)) {
                    return true;
                }
            }
            catch (NotRegisteredException ex) {
                return false;
            }
        }
        return false;
    }

    private static enum TownyRegion {
        wilderness,
        town,
        nation;

    }

    public static class TownyData {
        private boolean travel;
        private TownBlock townBlock;
        private Resident resident;

        boolean canTravel() {
            return this.travel;
        }

        void setCanTravel(boolean travel) {
            this.travel = travel;
        }

        TownBlock getTownBlock() {
            return this.townBlock;
        }

        void setTownBlock(TownBlock townBlock) {
            this.townBlock = townBlock;
        }

        Resident getResident() {
            return this.resident;
        }

        void setResident(Resident resident) {
            this.resident = resident;
        }
    }
}

