/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel.save;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.travel.save.TARDISSavesInventory;
import me.eccentric_nz.TARDIS.travel.save.TARDISSavesPlanetInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISSavesPlanetListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISSavesPlanetListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSavesPlanetClick(InventoryClickEvent event) {
        ItemMeta im;
        ItemStack is;
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof TARDISSavesPlanetInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int id = -1;
        if (this.plugin.getTrackerKeeper().getJunkPlayers().containsKey(uuid)) {
            id = this.plugin.getTrackerKeeper().getJunkPlayers().get(uuid);
        } else if (this.plugin.getTrackerKeeper().getSavesIds().containsKey(uuid)) {
            id = this.plugin.getTrackerKeeper().getSavesIds().get(uuid);
        } else {
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put("uuid", uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
            if (rst.resultSet()) {
                id = rst.getTardis_id();
            }
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        event.setCancelled(true);
        if (slot == 0 || slot == 2) {
            int travel;
            is = view.getItem(slot);
            if (is == null) {
                return;
            }
            im = is.getItemMeta();
            List lore = im.lore();
            World w = TARDISAliasResolver.getWorldFromAlias(ComponentUtils.stripColour((Component)lore.getFirst()));
            if (w == null) {
                this.close(player);
                return;
            }
            int x = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(1)));
            int y = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(2)));
            int z = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(3)));
            Location save_dest = new Location(w, (double)x, (double)y, (double)z);
            ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
            if (!rs.fromID(id)) {
                this.close(player);
                return;
            }
            int level = rs.getArtronLevel();
            if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                this.close(player);
                return;
            }
            Location exterior = null;
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (rsc.resultSet()) {
                exterior = rsc.getCurrent().location();
            }
            if (!save_dest.equals(exterior) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                String six;
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", ComponentUtils.stripColour((Component)lore.getFirst()));
                set.put("x", TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(1))));
                set.put("y", TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(2))));
                set.put("z", TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(3))));
                int l_size = lore.size();
                if (l_size >= 5) {
                    String four = ComponentUtils.stripColour((Component)lore.get(4));
                    if (!four.isEmpty() && !four.equals("Current location")) {
                        set.put("direction", four);
                    }
                    if (l_size > 5) {
                        String five = ComponentUtils.stripColour((Component)lore.get(5));
                        if (five.equals("true")) {
                            set.put("submarine", 1);
                        } else {
                            set.put("submarine", 0);
                        }
                    }
                }
                if (l_size >= 7 && !(six = ComponentUtils.stripColour((Component)lore.get(6))).equals("Current location")) {
                    HashMap<String, Object> sett = new HashMap<String, Object>();
                    sett.put("chameleon_preset", six);
                    sett.put("adapti_on", 0);
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    this.plugin.getQueryFactory().doSyncUpdate("tardis", sett, wheret);
                }
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", id);
                this.plugin.getQueryFactory().doSyncUpdate("next", set, wheret);
                TravelType travelType = ComponentUtils.stripColour(im.displayName()).equals("Home") ? TravelType.HOME : TravelType.SAVE;
                this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(travel, travelType));
                this.plugin.getTrackerKeeper().getRescue().remove(id);
                this.close(player);
                this.plugin.getMessenger().sendJoined(player, "DEST_SET_TERMINAL", ComponentUtils.stripColour(im.displayName()), !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    new TARDISLand(this.plugin, id, player).exitVortex();
                    this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, travelType, id));
                }
            } else if (!lore.contains(Component.text((String)"Current location", (TextColor)NamedTextColor.GOLD))) {
                lore.add(Component.text((String)"Current location", (TextColor)NamedTextColor.GOLD));
                im.lore(lore);
                is.setItemMeta(im);
            }
        }
        if (slot >= 8 && slot < 45 && (is = view.getItem(slot)) != null) {
            im = is.getItemMeta();
            String alias = ComponentUtils.stripColour(im.displayName());
            String world = TARDISAliasResolver.getWorldNameFromAlias(alias);
            player.openInventory(new TARDISSavesInventory(this.plugin, id, world).getInventory());
        }
    }
}

