/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSonic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.sonic.SonicActivatorInventory;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;

public class SonicActivatorListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final List<ItemStack> stacks;

    public SonicActivatorListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.stacks = this.getStacks();
    }

    private List<ItemStack> getStacks() {
        ShapedRecipe recipe = this.plugin.getFigura().getShapedRecipes().get("Sonic Generator");
        ArrayList<ItemStack> mats = new ArrayList<ItemStack>(recipe.getIngredientMap().values());
        mats.removeAll(Collections.singleton(null));
        return mats;
    }

    @EventHandler(ignoreCancelled=true)
    public void onActivatorMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof SonicActivatorInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot >= 0 && slot < 9) {
            switch (slot) {
                case 7: {
                    event.setCancelled(true);
                    break;
                }
                case 8: {
                    event.setCancelled(true);
                    this.save(p, event.getView());
                    break;
                }
            }
        } else {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISSonicActivatorListener");
                event.setCancelled(true);
            }
        }
    }

    private void save(Player p, InventoryView view) {
        Material m = Material.AIR;
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            ItemStack is = view.getItem(i);
            if (is == null || is.getType().equals((Object)m) || !this.stacks.contains(is)) continue;
            m = is.getType();
            ++count;
        }
        this.close(p);
        if (count == this.stacks.size()) {
            String uuid = p.getUniqueId().toString();
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put("uuid", uuid);
            ResultSetSonic rss = new ResultSetSonic(this.plugin, wheres);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("activated", 1);
            if (rss.resultSet() && !rss.getSonic().isActivated()) {
                HashMap<String, Object> wherea = new HashMap<String, Object>();
                wherea.put("uuid", uuid);
                this.plugin.getQueryFactory().doUpdate("sonic", set, wherea);
            } else {
                set.put("uuid", uuid);
                this.plugin.getQueryFactory().doInsert("sonic", set);
            }
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SONIC_ACTIVATED");
        } else {
            Location l = p.getLocation();
            World w = l.getWorld();
            for (int i = 0; i < 7; ++i) {
                ItemStack is = view.getItem(i);
                if (is == null) continue;
                w.dropItemNaturally(l, is);
            }
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SONIC_NOT_ACTIVATED");
        }
    }
}

