/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.setters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public class ItemFrameSetter {
    public static void curate(JsonArray frames, Location start, int id) {
        for (int i = 0; i < frames.size(); ++i) {
            JsonObject json = frames.get(i).getAsJsonObject();
            JsonObject rel = json.get("rel_location").getAsJsonObject();
            int px = rel.get("x").getAsInt();
            int py = rel.get("y").getAsInt();
            int pz = rel.get("z").getAsInt();
            BlockFace facing = BlockFace.valueOf((String)json.get("facing").getAsString());
            Location l = new Location(start.getWorld(), (double)(start.getBlockX() + px), (double)(start.getBlockY() + py), (double)(start.getBlockZ() + pz));
            ItemFrame frame = (ItemFrame)start.getWorld().spawnEntity(l, json.get("glowing").getAsBoolean() ? EntityType.GLOW_ITEM_FRAME : EntityType.ITEM_FRAME);
            frame.setFacingDirection(facing, true);
            String cmd = "";
            if (json.has("item")) {
                try {
                    Material material = Material.valueOf((String)json.get("item").getAsString());
                    ItemStack is = ItemStack.of((Material)material);
                    ItemMeta im = is.getItemMeta();
                    if (json.has("cmd")) {
                        cmd = json.get("cmd").getAsString();
                        if (!cmd.equals("st_johns")) {
                            NamespacedKey key = new NamespacedKey((Plugin)TARDIS.plugin, cmd);
                            im.setItemModel(key);
                        } else {
                            im.displayName((Component)Component.text((String)"St John's Logo"));
                            frame.setCustomNameVisible(false);
                        }
                    }
                    if (json.has("name")) {
                        im.displayName(ComponentUtils.fromJson(json.get("name")));
                    }
                    if (json.has("lore")) {
                        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                        for (JsonElement element : json.get("lore").getAsJsonArray()) {
                            lore.add(Component.text((String)element.getAsString()));
                        }
                        im.lore(lore);
                    }
                    if (json.has("banner")) {
                        JsonObject banner = json.get("banner").getAsJsonObject();
                        DyeColor baseColour = DyeColor.valueOf((String)banner.get("base_colour").getAsString());
                        JsonArray patterns = banner.get("patterns").getAsJsonArray();
                        ArrayList<Pattern> plist = new ArrayList<Pattern>();
                        for (int j = 0; j < patterns.size(); ++j) {
                            JsonObject jo = patterns.get(j).getAsJsonObject();
                            PatternType pt = (PatternType)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(new NamespacedKey("minecraft", jo.get("pattern").getAsString().toLowerCase(Locale.ROOT)));
                            if (pt == null) continue;
                            DyeColor dc = DyeColor.valueOf((String)jo.get("pattern_colour").getAsString());
                            Pattern p = new Pattern(dc, pt);
                            plist.add(p);
                        }
                        BlockStateMeta bsm = (BlockStateMeta)im;
                        Banner b = (Banner)bsm.getBlockState();
                        b.setBaseColor(baseColour);
                        b.setPatterns(plist);
                        bsm.setBlockState((BlockState)b);
                    }
                    is.setItemMeta(im);
                    frame.setItem(is, false);
                    if (json.has("rotation")) {
                        Rotation rotation = Rotation.valueOf((String)json.get("rotation").getAsString());
                        frame.setRotation(rotation);
                    }
                }
                catch (IllegalArgumentException e) {
                    TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not create item stack for schematic item frame!");
                }
            }
            if (json.has("rotor") && id != -1) {
                frame.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)cmd);
                TimeRotor.updateRotorRecord(id, frame.getUniqueId().toString());
            }
            if (json.has("microscope")) {
                frame.getPersistentDataContainer().set(TARDIS.plugin.getMicroscopeKey(), PersistentDataType.INTEGER, (Object)10000);
            }
            frame.setFixed(json.get("fixed").getAsBoolean());
            frame.setVisible(json.get("visible").getAsBoolean());
            Rotation rotation = Rotation.valueOf((String)json.get("rotation").getAsString());
            frame.setRotation(rotation);
        }
    }

    public static ItemFrame getItemFrameFromLocation(Location location) {
        BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1));
        for (Entity e2 : location.getWorld().getNearbyEntities(box, e -> e.getType() == EntityType.ITEM_FRAME)) {
            if (!(e2 instanceof ItemFrame)) continue;
            ItemFrame frame = (ItemFrame)e2;
            return frame;
        }
        return null;
    }
}

