/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.RoomCleaner;
import me.eccentric_nz.TARDIS.rooms.RoomDirection;
import me.eccentric_nz.TARDIS.rooms.RoomRemover;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class JettisonSeeder
implements Listener {
    private final TARDIS plugin;

    public JettisonSeeder(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRoomSeedBlockInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getJettison().containsKey(uuid)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null) {
            Material blockType = block.getType();
            Material inhand = player.getInventory().getItemInMainHand().getType();
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
            String key = rsp.resultSet() ? (!rsp.getKey().isEmpty() ? rsp.getKey() : this.plugin.getConfig().getString("preferences.key")) : this.plugin.getConfig().getString("preferences.key");
            if (blockType.equals((Object)Material.getMaterial((String)this.plugin.getArtronConfig().getString("jettison_seed"))) && inhand.equals((Object)Material.getMaterial((String)key))) {
                String room = this.plugin.getTrackerKeeper().getJettison().get(uuid);
                RoomDirection trd = new RoomDirection(block);
                trd.getDirection();
                if (!trd.isFound()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLATE_NOT_FOUND");
                    return;
                }
                COMPASS d = trd.getCompass();
                BlockFace facing = trd.getFace();
                Location l = block.getRelative(facing, 3).getLocation();
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                if (rs.fromUUID(player.getUniqueId().toString())) {
                    int id = rs.getTardisId();
                    RoomRemover remover = new RoomRemover(this.plugin, room, l, d, id);
                    if (remover.remove()) {
                        this.plugin.getTrackerKeeper().getJettison().remove(uuid);
                        block.setBlockData(TARDISConstants.AIR);
                        l.getWorld().playEffect(l, Effect.POTION_BREAK, 9);
                        int amount = Math.round((float)this.plugin.getArtronConfig().getInt("jettison") / 100.0f * (float)this.plugin.getRoomsConfig().getInt("rooms." + room + ".cost"));
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("uuid", player.getUniqueId().toString());
                        this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, set, player);
                        new RoomCleaner(this.plugin).removeRecords(room, id, block.getWorld(), player);
                        if (this.plugin.getConfig().getBoolean("growth.return_room_seed")) {
                            ItemStack is = ItemStack.of((Material)Material.getMaterial((String)this.plugin.getRoomsConfig().getString("rooms." + room + ".seed")));
                            PlayerInventory inv = player.getInventory();
                            inv.addItem(new ItemStack[]{is});
                            player.updateInventory();
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_AMOUNT", String.format("%d", amount));
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_HAS_JETT");
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ID_NOT_FOUND");
                }
            }
        }
    }
}

