/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.HADS;
import me.eccentric_nz.TARDIS.playerprefs.PreferencesProcessor;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PreferencesDialog {
    private final TARDIS plugin;
    private final UUID uuid;

    public PreferencesDialog(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    public Dialog create() {
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
        if (rsp.resultSet()) {
            HashMap<String, Object> wherep = new HashMap<String, Object>();
            wherep.put("uuid", this.uuid.toString());
            ResultSetTardis rst = new ResultSetTardis(this.plugin, wherep, "", false);
            if (rst.resultSet()) {
                Tardis tardis = rst.getTardis();
                ArrayList<Object> inputs = new ArrayList<Object>();
                inputs.add(DialogInput.bool((String)"announce_repeaters_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Announce repeaters", 180)), (boolean)rsp.isAnnounceRepeatersOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"auto_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Autonomous homing", 180)), (boolean)rsp.isAutoOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"auto_powerup_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Auto power up", 180)), (boolean)rsp.isAutoPowerUp(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"auto_rescue_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Auto rescue", 180)), (boolean)rsp.isAutoRescueOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"auto_siege_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Auto siege mode", 180)), (boolean)rsp.isAutoSiegeOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"beacon_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Beacon", 180)), (boolean)rsp.isBeaconOn(), (String)"1", (String)"0"));
                if (this.plugin.isWorldGuardOnServer()) {
                    inputs.add(DialogInput.bool((String)"build", (Component)Component.text((String)TARDISStringUtils.rightPad("Companion build", 180)), (boolean)rsp.isBuildOn(), (String)"1", (String)"0"));
                }
                inputs.add(DialogInput.bool((String)"close_gui_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Close GUIs", 180)), (boolean)rsp.isCloseGUIOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"dialogs_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Use dialogs", 180)), (boolean)rsp.isDialogsOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"dnd_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Do not disturb", 180)), (boolean)rsp.isDND(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"dynamic_lamps_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Dynamic lights", 180)), (boolean)rsp.isDynamicLightsOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"eps_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Emergency Programme One", 180)), (boolean)rsp.isEpsOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.text((String)"eps_message", (int)200, (Component)Component.text((String)"EP1 message"), (boolean)true, (String)rsp.getEpsMessage(), (int)256, (TextDialogInput.MultilineOptions)TextDialogInput.MultilineOptions.create((Integer)3, (Integer)32)));
                inputs.add(DialogInput.bool((String)"farm_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Farming", 180)), (boolean)rsp.isFarmOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.singleOption((String)"flight", (int)200, List.of(SingleOptionDialogInput.OptionEntry.create((String)"NORMAL", (Component)Component.text((String)"Normal"), (boolean)rsp.getHum().equals("ALIEN")), SingleOptionDialogInput.OptionEntry.create((String)"REGULATOR", (Component)Component.text((String)"Regulator"), (rsp.getFlightMode() == 2 ? 1 : 0) != 0), SingleOptionDialogInput.OptionEntry.create((String)"MANUAL", (Component)Component.text((String)"Manual"), (rsp.getFlightMode() == 3 ? 1 : 0) != 0), SingleOptionDialogInput.OptionEntry.create((String)"EXTERIOR", (Component)Component.text((String)"Exterior"), (rsp.getFlightMode() == 4 ? 1 : 0) != 0)), (Component)Component.text((String)"Flight mode"), (boolean)true));
                inputs.add(DialogInput.bool((String)"forcefield", (Component)Component.text((String)TARDISStringUtils.rightPad("Force field", 180)), (boolean)this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(this.uuid), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"hads_on", (Component)Component.text((String)TARDISStringUtils.rightPad("HADS", 180)), (boolean)rsp.isHadsOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.singleOption((String)"hads_type", (int)200, List.of(SingleOptionDialogInput.OptionEntry.create((String)"DISPLACEMENT", (Component)Component.text((String)"Displacement"), (boolean)rsp.getHadsType().equals((Object)HADS.DISPLACEMENT)), SingleOptionDialogInput.OptionEntry.create((String)"DISPERSAL", (Component)Component.text((String)"Dispersal"), (boolean)rsp.getHadsType().equals((Object)HADS.DISPERSAL))), (Component)Component.text((String)"HADS type"), (boolean)true));
                inputs.add(DialogInput.singleOption((String)"hum", (int)200, List.of(SingleOptionDialogInput.OptionEntry.create((String)"ALIEN", (Component)Component.text((String)"Alien"), (boolean)rsp.getHum().equals("alien")), SingleOptionDialogInput.OptionEntry.create((String)"ATMOSPHERE", (Component)Component.text((String)"Atmosphere"), (boolean)rsp.getHum().equals("atmosphere")), SingleOptionDialogInput.OptionEntry.create((String)"COMPUTER", (Component)Component.text((String)"Computer"), (boolean)rsp.getHum().equals("computer")), SingleOptionDialogInput.OptionEntry.create((String)"COPPER", (Component)Component.text((String)"Copper"), (boolean)rsp.getHum().equals("copper")), SingleOptionDialogInput.OptionEntry.create((String)"CORAL", (Component)Component.text((String)"Coral"), (boolean)rsp.getHum().equals("coral")), SingleOptionDialogInput.OptionEntry.create((String)"GALAXY", (Component)Component.text((String)"Galaxy"), (boolean)rsp.getHum().equals("galaxy")), SingleOptionDialogInput.OptionEntry.create((String)"LEARNING", (Component)Component.text((String)"Learning"), (boolean)rsp.getHum().equals("learning")), SingleOptionDialogInput.OptionEntry.create((String)"MIND", (Component)Component.text((String)"Mind"), (boolean)rsp.getHum().equals("mind")), SingleOptionDialogInput.OptionEntry.create((String)"NEON", (Component)Component.text((String)"Neon"), (boolean)rsp.getHum().equals("neon")), SingleOptionDialogInput.OptionEntry.create((String)"SLEEPING", (Component)Component.text((String)"Sleeping"), (boolean)rsp.getHum().equals("sleeping")), SingleOptionDialogInput.OptionEntry.create((String)"VOID", (Component)Component.text((String)"Void"), (boolean)rsp.getHum().equals("void")), SingleOptionDialogInput.OptionEntry.create((String)"RANDOM", (Component)Component.text((String)"Random"), (boolean)rsp.getHum().equals("random"))), (Component)Component.text((String)"Interior hum"), (boolean)true));
                inputs.add(DialogInput.bool((String)"info_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Info", 180)), (boolean)rsp.isInfoOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"isomorphic", (Component)Component.text((String)TARDISStringUtils.rightPad("Isomorphic controls", 180)), (boolean)tardis.isIsomorphicOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"junk_mode", (Component)Component.text((String)TARDISStringUtils.rightPad("Junk mode", 180)), (boolean)tardis.getPreset().equals((Object)ChameleonPreset.JUNK_MODE), (String)"1", (String)"0"));
                inputs.add(DialogInput.text((String)"key", (int)200, (Component)Component.text((String)"Key"), (boolean)true, (String)rsp.getKey(), (int)32, null));
                if (this.plugin.isWorldGuardOnServer()) {
                    String chunk = tardis.getChunk();
                    String[] split = chunk.split(":");
                    World world = this.plugin.getServer().getWorld(split[0]);
                    Player player = this.plugin.getServer().getPlayer(this.uuid);
                    inputs.add(DialogInput.bool((String)"lock_containers", (Component)Component.text((String)TARDISStringUtils.rightPad("Lock containers", 180)), (!this.plugin.getWorldGuardUtils().queryContainers(world, player.getName()) ? 1 : 0) != 0, (String)"1", (String)"0"));
                }
                inputs.add(DialogInput.bool((String)"minecart_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Minecart SFX", 180)), (boolean)rsp.isMinecartOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"open_display_door_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Open display door", 180)), (boolean)rsp.isOpenDisplayDoorOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"quotes_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Who quotes", 180)), (boolean)rsp.isQuotesOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"renderer_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Renderer room", 180)), (boolean)rsp.isRendererOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"sfx_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Sound effects", 180)), (boolean)rsp.isSfxOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"submarine_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Submarine mode", 180)), (boolean)rsp.isSubmarineOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"sign_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Exterior sign", 180)), (boolean)rsp.isSignOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"telepathy_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Telepathic circuit", 180)), (boolean)rsp.isTelepathyOn(), (String)"1", (String)"0"));
                inputs.add(DialogInput.bool((String)"travelbar_on", (Component)Component.text((String)TARDISStringUtils.rightPad("Show travel bar", 180)), (boolean)rsp.isTravelbarOn(), (String)"1", (String)"0"));
                DialogAction.CustomClickAction action = DialogAction.customClick((response, audience) -> {
                    Player player = audience instanceof Player ? (Player)audience : null;
                    new PreferencesProcessor(TARDIS.plugin, player).process(response);
                }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().build()));
                DialogBase dialogData = DialogBase.create((Component)Component.text((String)"Player Preferences"), null, (boolean)true, (boolean)true, (DialogBase.DialogAfterAction)DialogBase.DialogAfterAction.CLOSE, List.of(), inputs);
                ActionButton button = ActionButton.create((Component)Component.text((String)"Save"), null, (int)150, (DialogAction)action);
                return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(dialogData).type((DialogType)DialogType.notice((ActionButton)button)));
            }
        }
        return null;
    }
}

