/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.BlueprintConsole;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GallifreyBlueprintTrade {
    private final TARDIS plugin;
    private final int uses;

    public GallifreyBlueprintTrade(TARDIS plugin) {
        this.plugin = plugin;
        this.uses = Math.min(this.plugin.getPlanetsConfig().getInt("planets.gallifrey.villager_blueprints.uses"), 16);
    }

    public void setTrades(Merchant villager) {
        List<MerchantRecipe> recipes = this.getRandomRecipes();
        villager.setRecipes(recipes);
    }

    public MerchantRecipe getRoom() {
        BlueprintRoom bpr = BlueprintRoom.values()[TARDISConstants.RANDOM.nextInt(2, BlueprintRoom.values().length - 1)];
        ItemStack ris = this.buildResult(bpr.getPermission(), bpr.toString());
        MerchantRecipe roomRecipe = new MerchantRecipe(ris, this.uses);
        Material roomMaterial = Material.valueOf((String)TARDISARS.valueOf(bpr.toString()).getMaterial());
        int roomAmount = this.plugin.getRoomsConfig().getInt("rooms." + String.valueOf((Object)bpr) + ".cost") / 20;
        roomRecipe.addIngredient(ItemStack.of((Material)roomMaterial, (int)roomAmount));
        return roomRecipe;
    }

    public MerchantRecipe getConsole() {
        BlueprintConsole bpc = BlueprintConsole.values()[TARDISConstants.RANDOM.nextInt(BlueprintConsole.values().length - 1)];
        ItemStack cis = this.buildResult(bpc.getPermission(), bpc.toString());
        MerchantRecipe consoleRecipe = new MerchantRecipe(cis, this.uses);
        String perm = bpc.getPermission().split("\\.")[1];
        Material consoleMaterial = Desktops.getBY_PERMS().get(perm).getSeedMaterial();
        int consoleAmount = this.plugin.getArtronConfig().getInt("upgrades." + perm) / 250;
        consoleRecipe.addIngredient(ItemStack.of((Material)consoleMaterial, (int)consoleAmount));
        return consoleRecipe;
    }

    private List<MerchantRecipe> getRandomRecipes() {
        MerchantRecipe roomRecipe = this.getRoom();
        MerchantRecipe consoleRecipe = this.getConsole();
        return List.of(roomRecipe, consoleRecipe);
    }

    private ItemStack buildResult(String perm, String name) {
        ItemStack is = ItemStack.of((Material)Material.MUSIC_DISC_MELLOHI, (int)1);
        ItemMeta im = is.getItemMeta();
        PersistentDataContainer pdc = im.getPersistentDataContainer();
        pdc.set(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)UUID.randomUUID());
        pdc.set(this.plugin.getBlueprintKey(), PersistentDataType.STRING, (Object)perm);
        im.displayName((Component)Component.text((String)"TARDIS Blueprint Disk"));
        List<TextComponent> lore = List.of(ComponentUtils.toWhite(TARDISStringUtils.capitalise(name)), Component.text((String)"Valid only for"), Component.text((String)"the trading player"));
        im.lore(lore);
        im.addItemFlags(ItemFlag.values());
        im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
        is.setItemMeta(im);
        return is;
    }
}

