/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.particles.ParticleRunnable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Regeneration
extends ParticleRunnable
implements Runnable {
    private final Location location;
    private final float yaw;
    private final Particle particle = Particle.DUST_COLOR_TRANSITION;
    private final Particle.DustTransition transition = new Particle.DustTransition(Color.fromRGB((int)255, (int)182, (int)27), Color.fromRGB((int)255, (int)208, (int)27), 1.0f);
    private final List<Location> coords = new ArrayList<Location>();
    private final List<Vector> angles = new ArrayList<Vector>();

    public Regeneration(TARDIS plugin, Player player, Location location, float yaw) {
        super(plugin, player.getUniqueId());
        this.location = location;
        this.yaw = yaw;
        this.init();
    }

    private void init() {
        double angle = this.yawToAngle(this.yaw);
        double r = 1.25;
        double x = Math.cos(angle) * r;
        double z = Math.sin(angle) * r;
        Location head = this.location.clone().add(0.0, 1.85, 0.0);
        this.coords.add(head);
        Location left = this.location.clone().add(x, 0.8, z);
        this.coords.add(left);
        Location right = this.location.clone().add(-x, 0.8, -z);
        this.coords.add(right);
        this.angles.add(new Vector(0, 1, 0));
        Vector vl = left.clone().subtract(head).toVector().normalize();
        this.angles.add(vl);
        Vector vr = right.clone().subtract(head).toVector().normalize();
        this.angles.add(vr);
    }

    private void spawnTransitionParticles(Location location) {
        location.getWorld().spawnParticle(this.particle, location, 3, 0.15, 0.0, 0.15, 0.0, (Object)this.transition, false);
    }

    private double yawToAngle(float yaw) {
        if (yaw >= 360.0f) {
            yaw -= 360.0f;
        } else if (yaw < 0.0f) {
            yaw = 180.0f + (180.0f + yaw);
        }
        return Math.toRadians(yaw);
    }

    @Override
    public void run() {
        this.t += 0.1;
        int i = 0;
        for (Location l : this.coords) {
            double x = this.t * this.angles.get(i).getX();
            double y = this.t * this.angles.get(i).getY();
            double z = this.t * this.angles.get(i).getZ();
            if (++i > 2) {
                i = 0;
            }
            l.add(x, y, z);
            this.spawnTransitionParticles(l);
            l.subtract(x, y, z);
        }
        if (this.t > 2.0) {
            this.cancel();
        }
    }
}

