/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGravity;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.GravityWellRunnable;
import me.eccentric_nz.TARDIS.utility.VoidFall;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TARDISGravityWellListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<Double, Material> woolType = new HashMap();
    private final HashMap<Double, String> woolColour = new HashMap();

    public TARDISGravityWellListener(TARDIS plugin) {
        this.plugin = plugin;
        this.woolType.put(0.0, Material.PINK_WOOL);
        this.woolType.put(1.0, Material.LIME_WOOL);
        this.woolType.put(2.0, Material.BLACK_WOOL);
        this.woolType.put(3.0, Material.PURPLE_WOOL);
        this.woolType.put(4.0, Material.RED_WOOL);
        this.woolType.put(5.0, Material.YELLOW_WOOL);
        this.woolColour.put(0.0, "PINK");
        this.woolColour.put(1.0, "LIME");
        this.woolColour.put(2.0, "BLACK");
        this.woolColour.put(3.0, "PURPLE");
        this.woolColour.put(4.0, "RED");
        this.woolColour.put(5.0, "YELLOW");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        World world = event.getTo().getWorld();
        Location l = new Location(world, (double)event.getTo().getBlockX(), (double)(event.getTo().getBlockY() - 1), (double)event.getTo().getBlockZ(), 0.0f, 0.0f);
        String loc = l.toString();
        if (this.plugin.getGeneralKeeper().getGravityUpList().containsKey(loc)) {
            Player player = event.getPlayer();
            int x = l.getBlockX();
            int z = l.getBlockZ();
            Double[] values = this.plugin.getGeneralKeeper().getGravityUpList().get(loc);
            double end = l.getY() + values[1];
            double vel = values[2];
            GravityWellRunnable runnable = new GravityWellRunnable(this.plugin, player, vel, end, x, z, 1);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 2L, 3L);
            runnable.setTask(task);
            return;
        }
        if (this.plugin.getGeneralKeeper().getGravityNorthList().containsKey(loc)) {
            Player player = event.getPlayer();
            int x = l.getBlockX();
            int z = l.getBlockZ();
            Double[] values = this.plugin.getGeneralKeeper().getGravityNorthList().get(loc);
            double end = l.getZ() - values[1];
            double vel = values[2];
            GravityWellRunnable runnable = new GravityWellRunnable(this.plugin, player, vel, end, x, z, 2);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 2L, 3L);
            runnable.setTask(task);
            return;
        }
        if (this.plugin.getGeneralKeeper().getGravityWestList().containsKey(loc)) {
            Player player = event.getPlayer();
            int x = l.getBlockX();
            int z = l.getBlockZ();
            Double[] values = this.plugin.getGeneralKeeper().getGravityWestList().get(loc);
            double end = l.getX() - values[1];
            double vel = values[2];
            GravityWellRunnable runnable = new GravityWellRunnable(this.plugin, player, vel, end, x, z, 3);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 2L, 3L);
            runnable.setTask(task);
            return;
        }
        if (this.plugin.getGeneralKeeper().getGravitySouthList().containsKey(loc)) {
            Player player = event.getPlayer();
            int x = l.getBlockX();
            int z = l.getBlockZ();
            Double[] values = this.plugin.getGeneralKeeper().getGravitySouthList().get(loc);
            double end = l.getZ() + values[1];
            double vel = values[2];
            GravityWellRunnable runnable = new GravityWellRunnable(this.plugin, player, vel, end, x, z, 4);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 2L, 3L);
            runnable.setTask(task);
            return;
        }
        if (this.plugin.getGeneralKeeper().getGravityEastList().containsKey(loc)) {
            Player player = event.getPlayer();
            int x = l.getBlockX();
            int z = l.getBlockZ();
            Double[] values = this.plugin.getGeneralKeeper().getGravityEastList().get(loc);
            double end = l.getX() + values[1];
            double vel = values[2];
            GravityWellRunnable runnable = new GravityWellRunnable(this.plugin, player, vel, end, x, z, 5);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 2L, 3L);
            runnable.setTask(task);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent e) {
        Entity ent = e.getEntity();
        if (ent instanceof Player) {
            Player p = (Player)ent;
            Location l = ent.getLocation();
            switch (e.getCause()) {
                case FALL: {
                    l.setX((double)l.getBlockX());
                    l.setY((double)(l.getBlockY() - 1));
                    l.setZ((double)l.getBlockZ());
                    l.setPitch(0.0f);
                    l.setYaw(0.0f);
                    String loc = l.toString();
                    if (!this.plugin.getGeneralKeeper().getGravityDownList().contains(loc) && !this.plugin.getGeneralKeeper().getGravityUpList().containsKey(loc)) break;
                    e.setCancelled(true);
                    break;
                }
                case VOID: {
                    if (l.getBlockY() >= 1 || !this.plugin.getUtils().inTARDISWorld(p)) break;
                    if (this.plugin.getConfig().getString("preferences.vortex_fall").equals("kill")) {
                        p.damage(3.4028234663852886E38, DamageSource.builder((DamageType)DamageType.GENERIC_KILL).build());
                        break;
                    }
                    e.setCancelled(true);
                    new VoidFall(this.plugin).teleport(p);
                    break;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWoolInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.plugin.getTrackerKeeper().getGravity().containsKey(uuid)) {
            Double[] values = this.plugin.getTrackerKeeper().getGravity().get(uuid);
            Block b = event.getClickedBlock();
            if (b != null) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                if (!rs.fromUUID(player.getUniqueId().toString())) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                    return;
                }
                int id = rs.getTardisId();
                String loc = b.getLocation().toString();
                if (values[0] == 6.0) {
                    HashMap<String, Object> whereg = new HashMap<String, Object>();
                    whereg.put("tardis_id", id);
                    whereg.put("location", loc);
                    ResultSetGravity rsg = new ResultSetGravity(this.plugin, whereg, false);
                    if (rsg.resultSet()) {
                        HashMap<String, Object> whered = new HashMap<String, Object>();
                        whered.put("g_id", rsg.getGravity_id());
                        if (this.plugin.getQueryFactory().doSyncDelete("gravity_well", whered)) {
                            switch (rsg.getDirection()) {
                                case 1: {
                                    this.plugin.getGeneralKeeper().getGravityUpList().remove(loc);
                                    break;
                                }
                                case 2: {
                                    this.plugin.getGeneralKeeper().getGravityNorthList().remove(loc);
                                    break;
                                }
                                case 3: {
                                    this.plugin.getGeneralKeeper().getGravityWestList().remove(loc);
                                    break;
                                }
                                case 4: {
                                    this.plugin.getGeneralKeeper().getGravitySouthList().remove(loc);
                                    break;
                                }
                                case 5: {
                                    this.plugin.getGeneralKeeper().getGravityEastList().remove(loc);
                                    break;
                                }
                                default: {
                                    this.plugin.getGeneralKeeper().getGravityDownList().remove(loc);
                                }
                            }
                            Material floor = Material.LIGHT_GRAY_WOOL;
                            ResultSetPlayerPrefs rspp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                            if (rspp.resultSet()) {
                                floor = Material.valueOf((String)rspp.getFloor());
                            }
                            b.setBlockData(floor.createBlockData(), true);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_REMOVED");
                        }
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_NOT_FOUND");
                    }
                } else {
                    Material bit = this.woolType.get(values[0]);
                    if (!b.getType().equals((Object)bit)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_COLOUR", this.woolColour.get(values[0]) + ".");
                        return;
                    }
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("tardis_id", id);
                    set.put("location", loc);
                    set.put("direction", values[0].intValue());
                    set.put("distance", values[1].intValue());
                    set.put("velocity", values[2]);
                    this.plugin.getQueryFactory().doInsert("gravity_well", set);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_SET", switch (values[0].intValue()) {
                        case 1 -> {
                            this.plugin.getGeneralKeeper().getGravityUpList().put(loc, values);
                            yield "UP";
                        }
                        case 2 -> {
                            this.plugin.getGeneralKeeper().getGravityNorthList().put(loc, values);
                            yield "NORTH";
                        }
                        case 3 -> {
                            this.plugin.getGeneralKeeper().getGravityWestList().put(loc, values);
                            yield "WEST";
                        }
                        case 4 -> {
                            this.plugin.getGeneralKeeper().getGravitySouthList().put(loc, values);
                            yield "SOUTH";
                        }
                        case 5 -> {
                            this.plugin.getGeneralKeeper().getGravityEastList().put(loc, values);
                            yield "EAST";
                        }
                        default -> {
                            this.plugin.getGeneralKeeper().getGravityDownList().add(loc);
                            yield "DOWN";
                        }
                    });
                }
            }
            this.plugin.getTrackerKeeper().getGravity().remove(uuid);
        }
    }
}

