/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.customblocks.LampToggler;
import me.eccentric_nz.TARDIS.customblocks.TARDISChemistryDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISMushroomBlockData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.eye.SpaceHelmetListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TARDISBlockPlaceListener
implements Listener {
    private final TARDIS plugin;

    public TARDISBlockPlaceListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerBlockPlace(BlockPlaceEvent event) {
        ItemMeta im;
        ItemStack is;
        Player player = event.getPlayer();
        if (this.plugin.getTrackerKeeper().getZeroRoomOccupants().contains(player.getUniqueId())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_ZERO");
            return;
        }
        Block block = event.getBlockPlaced();
        String blockStr = block.getLocation().toString();
        if (this.plugin.getGeneralKeeper().getProtectBlockMap().containsKey(blockStr)) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PLACE");
        }
        if (SpaceHelmetListener.isSpaceHelmet(is = event.getItemInHand())) {
            event.setCancelled(true);
            return;
        }
        if ((is.getType().equals((Object)Material.BROWN_MUSHROOM_BLOCK) || is.getType().equals((Object)Material.RED_MUSHROOM_BLOCK) || is.getType().equals((Object)Material.MUSHROOM_STEM)) && is.hasItemMeta() && (im = is.getItemMeta()).getPersistentDataContainer().has(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER)) {
            TARDISDisplayItem tdi = TARDISMushroomBlockData.getTARDISBlock(block.getBlockData());
            if (tdi != null) {
                if (tdi == TARDISChemistryDisplayItem.HEAT_BLOCK) {
                    this.plugin.getTrackerKeeper().getHeatBlocks().add(blockStr);
                }
                if (tdi.isLight()) {
                    LampToggler.setLightlevel(block, tdi.isLit() ? 15 : 0);
                    TARDISDisplayItemUtils.set(block.getLocation(), tdi.getCustomModel().getKey(), false);
                } else {
                    block.setBlockData(TARDISConstants.BARRIER);
                }
                TARDISDisplayItemUtils.set(tdi, block, -1);
            }
            return;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.rift")) {
            return;
        }
        if (!is.getType().equals((Object)Material.BEACON) || !is.hasItemMeta()) {
            return;
        }
        im = is.getItemMeta();
        if (im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Rift Manipulator")) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
            if (rst.resultSet()) {
                event.setCancelled(true);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RIFT_OUTSIDE");
                return;
            }
            Location l = block.getLocation();
            String name = "rift_" + player.getName() + "_" + TARDISConstants.RANDOM.nextInt(Integer.MAX_VALUE);
            while (this.plugin.getConfig().contains("rechargers." + name)) {
                name = "rift_" + player.getName() + "_" + TARDISConstants.RANDOM.nextInt(Integer.MAX_VALUE);
            }
            this.plugin.getConfig().set("rechargers." + name + ".world", (Object)l.getWorld().getName());
            this.plugin.getConfig().set("rechargers." + name + ".x", (Object)l.getBlockX());
            this.plugin.getConfig().set("rechargers." + name + ".y", (Object)l.getBlockY());
            this.plugin.getConfig().set("rechargers." + name + ".z", (Object)l.getBlockZ());
            this.plugin.getConfig().set("rechargers." + name + ".uuid", (Object)player.getUniqueId().toString());
            this.plugin.saveConfig();
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RIFT_SUCCESS");
        }
    }
}

