/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.desktop.WallListener;
import me.eccentric_nz.TARDIS.desktop.WallsInventory;
import me.eccentric_nz.TARDIS.lights.LightsInventory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VariableLightBlocksListener
extends WallListener {
    private final TARDIS plugin;

    public VariableLightBlocksListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onVariableLightBlockMenuOpen(InventoryOpenEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof WallsInventory)) {
            return;
        }
        WallsInventory lights = (WallsInventory)inventoryHolder;
        if (lights.getTitle().equals("Variable Light Blocks")) {
            Player player = (Player)event.getPlayer();
            this.scroll.put(player.getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onVariableLightBlockClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof WallsInventory)) {
            return;
        }
        WallsInventory lights = (WallsInventory)inventoryHolder;
        if (!lights.getTitle().equals("Variable Light Blocks")) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int slot = event.getRawSlot();
        InventoryView view = event.getView();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISVariableLightBlocksListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 8: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, (Integer)this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 17: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, (Integer)this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 26: {
                String wall = this.getWallFloor(uuid, true);
                this.setVariableLightBlock(player, wall);
                break;
            }
            case 35: {
                String floor = this.getWallFloor(uuid, false);
                this.setVariableLightBlock(player, floor);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                ItemStack choice = view.getItem(slot);
                this.setVariableLightBlock(player, choice.getType().toString());
            }
        }
    }

    private void setVariableLightBlock(Player player, String block) {
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        UUID uuid = player.getUniqueId();
        if (rst.fromUUID(uuid.toString())) {
            int id = rst.getTardisId();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("material", block);
            ResultSetLightPrefs rslp = new ResultSetLightPrefs(this.plugin);
            if (rslp.fromID(rst.getTardisId())) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                this.plugin.getQueryFactory().doUpdate("light_prefs", set, where);
            } else {
                set.put("tardis_id", id);
                this.plugin.getQueryFactory().doSyncInsert("light_prefs", set);
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new LightsInventory(this.plugin, id, uuid).getInventory()), 5L);
        }
    }
}

