/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.lights.LightEmittingInventory;
import me.eccentric_nz.TARDIS.lights.LightsInventory;
import me.eccentric_nz.TARDIS.lights.Sequences;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LightEmittingListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public LightEmittingListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightEmittingBlockClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof LightEmittingInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 27) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISLightEmittingListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 24: {
                ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                if (!rst.fromUUID(uuid.toString())) break;
                player.openInventory(new LightsInventory(this.plugin, rst.getTardisId(), uuid).getInventory());
                break;
            }
            case 26: {
                this.close(player);
                break;
            }
            default: {
                ItemStack choice = event.getView().getItem(slot);
                this.setEmittingLightBlock(player, choice.getType().toString());
            }
        }
    }

    private void setEmittingLightBlock(Player player, String block) {
        Sequences.CONVERTERS.put(player.getUniqueId(), block);
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        UUID uuid = player.getUniqueId();
        if (rst.fromUUID(uuid.toString())) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new LightsInventory(this.plugin, rst.getTardisId(), uuid).getInventory()), 5L);
        }
    }
}

