/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.VariableLight;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LightChanger
implements Runnable {
    final List<Chunk> chunks = new ArrayList<Chunk>();
    private final TARDIS plugin;
    private final TardisLight light;
    private final boolean lightsOn;
    private final Material material;
    private final UUID uuid;
    int index = 0;
    int taskID;
    private BossBar bb;

    public LightChanger(TARDIS plugin, TardisLight light, String chunk, boolean lightsOn, Material material, Player player) {
        this.plugin = plugin;
        this.light = light;
        this.lightsOn = lightsOn;
        this.material = material;
        this.uuid = player.getUniqueId();
        plugin.getTrackerKeeper().getLightChangers().add(this.uuid);
        String[] tc = chunk.split(":");
        int cx = TARDISNumberParsers.parseInt(tc[1]);
        int cz = TARDISNumberParsers.parseInt(tc[2]);
        World world = TARDISAliasResolver.getWorldFromAlias(tc[0]);
        if (world != null) {
            for (int x = -4; x < 5; ++x) {
                for (int z = -4; z < 5; ++z) {
                    Chunk c = world.getChunkAt(cx + x, cz + z);
                    if (c.getEntities().length <= 0) continue;
                    this.chunks.add(c);
                }
            }
            this.bb = Bukkit.createBossBar((String)"TARDIS Light Changer Progress", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])TARDISConstants.EMPTY_ARRAY);
            this.bb.setProgress(0.0);
            this.bb.addPlayer(player);
            this.bb.setVisible(true);
        }
    }

    @Override
    public void run() {
        for (Entity e : this.chunks.get(this.index).getEntities()) {
            TARDISDisplayItem tdi;
            Interaction interaction;
            ItemDisplay display;
            if (!(e instanceof Interaction) || (display = TARDISDisplayItemUtils.get(interaction = (Interaction)e)) == null || (tdi = TARDISDisplayItemUtils.get(display)) == null || !tdi.isLight()) continue;
            Block block = interaction.getLocation().getBlock();
            block.setType(Material.AIR);
            TARDISDisplayItemUtils.remove(block);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                if (this.light.getOn().isVariable()) {
                    new VariableLight(this.material, block.getLocation().add(0.5, 0.5, 0.5)).set(this.lightsOn ? this.light.getOn().getCustomModel() : this.light.getOff().getCustomModel(), this.lightsOn ? 15 : 0);
                } else {
                    TARDISDisplayItemUtils.set(this.lightsOn ? this.light.getOn() : this.light.getOff(), block, -1);
                }
            }, 3L);
        }
        ++this.index;
        double progress = (double)this.index / ((double)this.chunks.size() * 1.0);
        this.bb.setProgress(progress);
        if (this.index > this.chunks.size() - 1) {
            this.plugin.getServer().getScheduler().cancelTask(this.taskID);
            this.bb.setProgress(1.0);
            this.bb.setVisible(false);
            this.bb.removeAll();
            this.plugin.getTrackerKeeper().getLightChangers().remove(this.uuid);
        }
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }
}

