/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISRecipeTabComplete;
import me.eccentric_nz.TARDIS.commands.handles.TeleportCommand;
import me.eccentric_nz.TARDIS.commands.handles.TransmatCommand;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.control.TARDISRandomButton;
import me.eccentric_nz.TARDIS.control.actions.LightSwitchAction;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHandlesTransmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.HandlesPattern;
import me.eccentric_nz.TARDIS.handles.HandlesPlaceholder;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class HandlesRequest {
    private final TARDIS plugin;
    private final Pattern handlesPattern;

    public HandlesRequest(TARDIS plugin) {
        this.plugin = plugin;
        this.handlesPattern = HandlesPattern.getPattern("prefix", false);
    }

    public void process(UUID uuid, String chat) {
        Player player = this.plugin.getServer().getPlayer(uuid);
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.handles.use")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return;
        }
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (rs.fromUUID(uuid.toString())) {
            int i;
            Pattern pattern;
            Object m;
            int id = rs.getTardisId();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            where.put("type", 26);
            ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
            if (rsc.resultSet()) {
                if (!this.plugin.getUtils().inTARDISWorld(player)) {
                    if (!TARDISPermission.hasPermission(player, "tardis.handles.communicator")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_COMMUNICATOR");
                        return;
                    }
                    PlayerInventory pi = player.getInventory();
                    ItemStack communicator = pi.getHelmet();
                    if (!(communicator != null && communicator.hasItemMeta() && communicator.getType().equals((Object)Material.LEATHER_HELMET) && ComponentUtils.endsWith(communicator.getItemMeta().displayName(), "TARDIS Communicator"))) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HANDLES_COMMUNICATOR");
                        return;
                    }
                }
            } else {
                boolean found = false;
                for (Object is : player.getInventory().getContents()) {
                    ItemMeta im;
                    if (is == null || !is.getType().equals((Object)Material.BIRCH_BUTTON) || !is.hasItemMeta() || !(im = is.getItemMeta()).hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "Handles")) continue;
                    found = true;
                }
                if (!found) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HANDLES_INVENTORY");
                    return;
                }
            }
            String removed = chat.replaceAll("(?i)" + String.valueOf(this.handlesPattern), "").trim();
            boolean matched = false;
            String key = "";
            ArrayList<String> groups = null;
            for (String k : this.plugin.getHandlesConfig().getConfigurationSection("core-commands").getKeys(true)) {
                if (k.equals("travel") || k.equals("door") || !((Matcher)(m = (pattern = HandlesPattern.getPattern(k, false)).matcher(removed))).find()) continue;
                matched = true;
                key = k;
                if (((Matcher)m).groupCount() <= 0) break;
                groups = new ArrayList<String>();
                for (i = 0; i < ((Matcher)m).groupCount(); ++i) {
                    groups.add(((Matcher)m).group(i + 1));
                }
            }
            if (matched) {
                switch (key) {
                    case "craft": {
                        if (groups == null) break;
                        String tardis = (String)groups.get(1);
                        if (tardis == null || tardis.isEmpty()) {
                            for (String item : TARDISRecipeTabComplete.ROOT_SUBS) {
                                if (!((String)groups.get(2)).equalsIgnoreCase(item)) continue;
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardisrecipe " + item), 1L);
                                return;
                            }
                        } else {
                            for (String seed : TARDISRecipeTabComplete.TARDIS_TYPES) {
                                if (!((String)groups.getFirst()).equalsIgnoreCase(seed)) continue;
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardisrecipe tardis " + seed), 1L);
                                return;
                            }
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardisrecipe tardis budget"), 1L);
                            return;
                        }
                        this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                        break;
                    }
                    case "remind": {
                        if (!this.plugin.getHandlesConfig().getBoolean("reminders.enabled")) {
                            this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                            return;
                        }
                        if (groups == null) break;
                        String reminder = (String)groups.getFirst();
                        String time = (String)groups.get(1);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles remind " + String.valueOf(uuid) + " " + reminder + " " + time), 1L);
                        return;
                    }
                    case "say": {
                        if (groups == null) break;
                        String g = (String)groups.getFirst();
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles say " + String.valueOf(uuid) + " " + StringUtils.normalizeSpace((String)g)), 1L);
                        break;
                    }
                    case "name": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles name " + String.valueOf(uuid)), 1L);
                        break;
                    }
                    case "time": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles time " + String.valueOf(uuid)), 1L);
                        break;
                    }
                    case "call": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles call " + String.valueOf(uuid) + " " + id), 1L);
                        break;
                    }
                    case "takeoff": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles takeoff " + String.valueOf(uuid) + " " + id), 1L);
                        break;
                    }
                    case "land": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles land " + String.valueOf(uuid) + " " + id), 1L);
                        break;
                    }
                    case "hide": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardis hide"), 1L);
                        break;
                    }
                    case "rebuild": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardis rebuild"), 1L);
                        break;
                    }
                    case "brake": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles brake on " + String.valueOf(uuid) + " " + id), 1L);
                        break;
                    }
                    case "direction": {
                        if (groups == null) break;
                        COMPASS direction = null;
                        if (((String)groups.getFirst()).equalsIgnoreCase("east")) {
                            direction = COMPASS.EAST;
                        } else if (((String)groups.getFirst()).equalsIgnoreCase("north")) {
                            direction = COMPASS.NORTH;
                        } else if (((String)groups.getFirst()).equalsIgnoreCase("west")) {
                            direction = COMPASS.WEST;
                        } else if (((String)groups.getFirst()).equalsIgnoreCase("south")) {
                            direction = COMPASS.SOUTH;
                        }
                        if (direction == null) break;
                        String d = direction.toString();
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardis direction " + d), 1L);
                        break;
                    }
                    case "lights": {
                        if (groups == null) break;
                        boolean onoff = ((String)groups.getFirst()).equalsIgnoreCase("on");
                        HashMap<String, Object> wherel = new HashMap<String, Object>();
                        wherel.put("tardis_id", id);
                        ResultSetTardis rst = new ResultSetTardis(this.plugin, wherel, "", false);
                        if (!rst.resultSet()) break;
                        Tardis tardis = rst.getTardis();
                        if ((!onoff || tardis.isLightsOn()) && (onoff || !tardis.isLightsOn())) break;
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new LightSwitchAction(this.plugin, id, tardis.isLightsOn(), player, tardis.getSchematic().getLights()).flickSwitch(), 1L);
                        break;
                    }
                    case "power": {
                        if (groups == null) break;
                        boolean onoff = ((String)groups.getFirst()).equalsIgnoreCase("off");
                        HashMap<String, Object> wherel = new HashMap();
                        wherel.put("tardis_id", id);
                        ResultSetTardis rst = new ResultSetTardis(this.plugin, wherel, "", false);
                        if (!rst.resultSet()) break;
                        Tardis tardis = rst.getTardis();
                        if ((!onoff || !tardis.isPoweredOn()) && (onoff || tardis.isPoweredOn()) || !this.plugin.getConfig().getBoolean("allow.power_down")) break;
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISPowerButton(this.plugin, id, player, tardis.getPreset(), tardis.isPoweredOn(), tardis.isHidden(), tardis.isLightsOn(), player.getLocation(), tardis.getArtronLevel(), tardis.getSchematic().getLights()).clickButton(), 1L);
                        break;
                    }
                    case "travel.save": {
                        if (groups == null) break;
                        HashMap<String, Object> wheres = new HashMap<String, Object>();
                        wheres.put("tardis_id", id);
                        ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wheres, true);
                        if (!rsd.resultSet()) break;
                        for (HashMap<String, String> map : rsd.getData()) {
                            String dest = map.get("dest_name");
                            if (!((String)groups.getFirst()).equalsIgnoreCase(dest) || !TARDISPermission.hasPermission(player, "tardis.timetravel")) continue;
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel dest " + dest + " kzsbtr1h2"), 1L);
                            return;
                        }
                        break;
                    }
                    case "travel.home": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel home kzsbtr1h2"), 1L);
                        break;
                    }
                    case "travel.random": {
                        HashMap<String, Integer> wherel = new HashMap<String, Integer>();
                        wherel.put("tardis_id", id);
                        ResultSetTardis rsr = new ResultSetTardis(this.plugin, (HashMap<String, Object>)wherel, "", false);
                        if (!rsr.resultSet()) break;
                        Tardis tardis = rsr.getTardis();
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISRandomButton(this.plugin, player, id, tardis.getArtronLevel(), 0, tardis.getCompanions(), tardis.getUuid()).clickButton(), 1L);
                        return;
                    }
                    case "travel.player": {
                        if (groups == null) break;
                        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.player")) {
                            this.plugin.getMessenger().handlesSend(player, "NO_PERM_PLAYER");
                            return;
                        }
                        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                            String name = p.getName();
                            if (((String)groups.getFirst()).equalsIgnoreCase(name)) {
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel " + name + " kzsbtr1h2"), 1L);
                                return;
                            }
                            this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                        }
                        break;
                    }
                    case "travel.area": {
                        if (groups == null) break;
                        String area = groups.getFirst() == null || ((String)groups.getFirst()).isEmpty() ? (String)groups.get(1) : (String)groups.getFirst();
                        ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, false, true);
                        if (!rsa.resultSet()) break;
                        for (String name : rsa.getNames()) {
                            if (!area.equalsIgnoreCase(name) || !TARDISPermission.hasPermission(player, "tardis.area." + name) && !TARDISPermission.hasPermission(player, "tardis.area.*")) continue;
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel area " + name + " kzsbtr1h2"), 1L);
                            return;
                        }
                        this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                        break;
                    }
                    case "travel.biome": {
                        if (groups == null) break;
                        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.biome")) {
                            this.plugin.getMessenger().handlesSend(player, "TRAVEL_NO_PERM_BIOME");
                            return;
                        }
                        String gb = groups.getFirst() == null || ((String)groups.getFirst()).isEmpty() ? (String)groups.get(1) : (String)groups.getFirst();
                        for (Biome biome : RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME)) {
                            String b = biome.getKey().getKey().toUpperCase(Locale.ROOT);
                            if (!gb.equalsIgnoreCase(b)) continue;
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel biome " + b + " kzsbtr1h2"), 1L);
                            return;
                        }
                        this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                        break;
                    }
                    case "travel.cave": {
                        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.cave")) {
                            this.plugin.getMessenger().handlesSend(player, "TRAVEL_NO_PERM_CAVE");
                            return;
                        }
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel cave kzsbtr1h2"), 1L);
                        break;
                    }
                    case "travel.village": {
                        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.village")) {
                            this.plugin.getMessenger().handlesSend(player, "TRAVEL_NO_PERM_VILLAGE");
                            return;
                        }
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardistravel village kzsbtr1h2"), 1L);
                        break;
                    }
                    case "door.open": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardis door OPEN"), 1L);
                        break;
                    }
                    case "door.close": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand("tardis door CLOSE"), 1L);
                        break;
                    }
                    case "door.lock": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles lock " + String.valueOf(uuid) + " " + id + " true"), 1L);
                        break;
                    }
                    case "door.unlock": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles unlock " + String.valueOf(uuid) + " " + id + " false"), 1L);
                        break;
                    }
                    case "scan": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles scan " + String.valueOf(uuid) + " " + id), 1L);
                        break;
                    }
                    case "teleport": {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TeleportCommand(this.plugin).beamMeUp(player), 1L);
                        break;
                    }
                    case "transmat": {
                        if (groups == null) break;
                        if (!TARDISPermission.hasPermission(player, "tardis.transmat")) {
                            this.plugin.getMessenger().handlesSend(player, "NO_PERMS");
                            return;
                        }
                        Location location = player.getLocation();
                        if (!this.plugin.getUtils().inTARDISWorld(location)) {
                            this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_TRANSMAT_WORLD");
                            return;
                        }
                        ResultSetHandlesTransmat rst = new ResultSetHandlesTransmat(this.plugin, id);
                        if (rst.findSite((String)groups.getFirst())) {
                            new TransmatCommand(this.plugin).siteToSiteTransport(player, rst.getLocation());
                            break;
                        }
                        this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_TRANSMAT");
                        break;
                    }
                }
                if (key.equals("remind")) {
                    TARDISSounds.playTARDISSound(player, "handles_confirmed", 5L);
                }
            } else {
                for (String k : this.plugin.getHandlesConfig().getConfigurationSection("custom-commands").getKeys(false)) {
                    pattern = HandlesPattern.getPattern(k, true);
                    m = pattern.matcher(removed);
                    if (!((Matcher)m).find()) continue;
                    matched = true;
                    key = k;
                    if (((Matcher)m).groupCount() <= 0) continue;
                    groups = new ArrayList();
                    for (i = 0; i < ((Matcher)m).groupCount(); ++i) {
                        groups.add(((Matcher)m).group(i + 1));
                    }
                }
                if (matched) {
                    String perm = this.plugin.getHandlesConfig().getString("custom-commands." + key + ".permission");
                    if (perm != null && TARDISPermission.hasPermission(player, perm)) {
                        for (String cmd : this.plugin.getHandlesConfig().getStringList("custom-commands." + key + ".commands")) {
                            boolean isConsoleCommand;
                            String command;
                            if (cmd.contains("%") && this.plugin.getPM().isPluginEnabled("PlaceholderAPI")) {
                                cmd = HandlesPlaceholder.getSubstituted(cmd, (OfflinePlayer)player);
                            }
                            if (groups != null) {
                                for (int g = groups.size() - 1; g >= 0; --g) {
                                    String find = "$" + (g + 1);
                                    cmd = cmd.replace(find, (CharSequence)groups.get(g));
                                }
                            }
                            String string = command = (isConsoleCommand = cmd.startsWith("^")) ? cmd.substring(1) : cmd;
                            if (isConsoleCommand) {
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), command), 1L);
                                continue;
                            }
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.performCommand(command), 1L);
                        }
                    }
                    TARDISSounds.playTARDISSound(player, "handles_confirmed", 5L);
                } else {
                    this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                }
            }
        }
    }
}

