/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.forcefield;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class ForceFieldPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public ForceFieldPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void save() {
        if (!this.plugin.getTrackerKeeper().getActiveForceFields().isEmpty()) {
            try {
                this.connection.setAutoCommit(false);
                this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "forcefield (uuid, location) VALUES (?, ?)");
                for (Map.Entry<UUID, Location> map : this.plugin.getTrackerKeeper().getActiveForceFields().entrySet()) {
                    this.ps.setString(1, map.getKey().toString());
                    this.ps.setString(2, map.getValue().toString());
                    this.ps.addBatch();
                    ++this.count;
                }
                this.ps.executeBatch();
                this.connection.setAutoCommit(true);
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " TARDIS force fields.");
            }
            catch (SQLException e) {
                this.plugin.debug("Insert error for force field query: " + e.getMessage());
            }
            finally {
                try {
                    if (this.ps != null) {
                        this.ps.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing force field statement: " + e.getMessage());
                }
            }
        }
    }

    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT uuid, location FROM " + this.prefix + "forcefield");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    UUID uuid = UUID.fromString(this.rs.getString("uuid"));
                    Location location = TARDISStaticLocationGetters.getLocationFromBukkitString(this.rs.getString("location"));
                    this.plugin.getTrackerKeeper().getActiveForceFields().put(uuid, location);
                    ++this.count;
                }
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " TARDIS force fields.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "forcefield");
            this.ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for force field query: " + e.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing force field statement or resultset: " + e.getMessage());
            }
        }
    }
}

