/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.desktop.DesktopThemeProcessor;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.desktop.WallListener;
import me.eccentric_nz.TARDIS.desktop.WallsInventory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WallMenuListener
extends WallListener {
    private final TARDIS plugin;

    public WallMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onWallMenuOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof WallsInventory) {
            Player player = (Player)event.getPlayer();
            this.scroll.put(player.getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWallMenuClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof WallsInventory)) {
            return;
        }
        WallsInventory walls = (WallsInventory)holder;
        boolean isWall = walls.getTitle().equals("TARDIS Wall Menu");
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISWallMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 8: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, (Integer)this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 17: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, (Integer)this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 26: {
                String wall = this.getWallFloor(uuid, true);
                this.setWallFloorBlock(player, uuid, wall, isWall);
                break;
            }
            case 35: {
                String floor = this.getWallFloor(uuid, false);
                this.setWallFloorBlock(player, uuid, floor, isWall);
                break;
            }
            case 53: {
                this.close(player, true);
                break;
            }
            default: {
                ItemStack choice = view.getItem(slot);
                this.setWallFloorBlock(player, uuid, choice.getType().toString(), isWall);
            }
        }
    }

    private void setWallFloorBlock(Player p, UUID uuid, String str, boolean isWall) {
        UpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(uuid);
        if (isWall) {
            tud.setWall(str);
            this.floor(p);
        } else {
            tud.setFloor(str);
            this.close(p, false);
            new DesktopThemeProcessor(this.plugin, uuid).changeDesktop();
        }
        this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
    }

    private void floor(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.openInventory(new WallsInventory(this.plugin, "TARDIS Floor Menu").getInventory()), 1L);
    }
}

