/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.ConsoleInteraction;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetInteraction {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final UUID uuid;
    private int interaction_id;
    private int tardis_id;
    private ConsoleInteraction control;
    private int state;

    public ResultSetInteraction(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "interactions WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid.toString());
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.interaction_id = rs.getInt("i_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.control = ConsoleInteraction.valueOf(rs.getString("control"));
                        this.state = rs.getInt("state");
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for interactions table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing interactions table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getTardisId() {
        return this.tardis_id;
    }

    public ConsoleInteraction getControl() {
        return this.control;
    }

    public int getState() {
        return this.state;
    }
}

