/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConsole;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetOccupied;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;

public class ControlRunnable
implements Runnable {
    private final TARDIS plugin;
    private int modulo = 0;

    public ControlRunnable(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        ResultSetOccupied rso = new ResultSetOccupied(this.plugin);
        rso.resultSetAsync(resultSetOccupied -> {
            for (int id : rso.getData()) {
                ResultSetConsole rsc = new ResultSetConsole(this.plugin, id);
                if (this.modulo % 2 == 0) {
                    rsc.locationAsync((hasResult, resultSetConsole) -> {
                        if (hasResult && Tag.ALL_SIGNS.isTagged((Keyed)resultSetConsole.getSign().getType())) {
                            Sign sign = (Sign)resultSetConsole.getSign().getState();
                            SignSide front = sign.getSide(Side.FRONT);
                            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                                front.line(0, (Component)Component.text((String)"Drifting", (TextColor)NamedTextColor.DARK_PURPLE));
                                front.line(1, (Component)Component.text((String)"in the", (TextColor)NamedTextColor.DARK_PURPLE));
                                front.line(2, (Component)Component.text((String)"time", (TextColor)NamedTextColor.DARK_PURPLE));
                                front.line(3, (Component)Component.text((String)"vortex...", (TextColor)NamedTextColor.DARK_PURPLE));
                            } else {
                                String worldName;
                                String string = worldName = resultSetConsole.getWorld() != null ? TARDISAliasResolver.getWorldAlias(resultSetConsole.getWorld()) : "";
                                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + resultSetConsole.getWorld() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) && !worldName.isEmpty()) {
                                    worldName = this.plugin.getMVHelper().getAlias(worldName);
                                }
                                front.line(0, (Component)Component.text((String)worldName, (TextColor)NamedTextColor.DARK_PURPLE));
                                front.line(1, (Component)Component.text((String)resultSetConsole.getX(), (TextColor)NamedTextColor.BLACK));
                                front.line(2, (Component)Component.text((String)resultSetConsole.getY(), (TextColor)NamedTextColor.BLACK));
                                front.line(3, (Component)Component.text((String)resultSetConsole.getZ(), (TextColor)NamedTextColor.BLACK));
                            }
                            sign.update();
                        }
                    });
                    continue;
                }
                rsc.artronAsync((hasResult, resultSetConsole) -> {
                    if (hasResult && Tag.ALL_SIGNS.isTagged((Keyed)resultSetConsole.getSign().getType())) {
                        TextComponent preset;
                        Sign sign = (Sign)resultSetConsole.getSign().getState();
                        SignSide front = sign.getSide(Side.FRONT);
                        front.line(0, (Component)Component.text((String)this.plugin.getLanguage().getString("ARTRON_DISPLAY", "Artron Energy"), (TextColor)NamedTextColor.BLACK));
                        front.line(1, (Component)Component.text((String)resultSetConsole.getArtronLevel(), (TextColor)NamedTextColor.AQUA));
                        front.line(2, (Component)Component.text((String)this.plugin.getLanguage().getString("CHAM_DISPLAY", "Exterior"), (TextColor)NamedTextColor.BLACK));
                        if (resultSetConsole.getPreset().startsWith("POLICE_BOX_")) {
                            NamedTextColor colour = TARDISStaticUtils.policeBoxToNamedTextColor(resultSetConsole.getPreset());
                            preset = Component.text((String)"POLICE_BOX", (TextColor)colour);
                        } else {
                            preset = Component.text((String)resultSetConsole.getPreset().replace("ITEM:", ""), (TextColor)NamedTextColor.BLUE);
                        }
                        front.line(3, (Component)preset);
                        sign.update();
                    }
                });
            }
        });
        ++this.modulo;
        if (this.modulo == 2) {
            this.modulo = 0;
        }
    }
}

