/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.InteractionResponse;
import me.eccentric_nz.TARDIS.console.models.LightLevelModel;
import me.eccentric_nz.TARDIS.control.actions.LightLevelAction;
import me.eccentric_nz.TARDIS.database.InteractionStateSaver;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightLevel;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;

public class LightLevelInteraction {
    private final TARDIS plugin;

    public LightLevelInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void setInterior(int state, int id, Interaction interaction, Player player) {
        ResultSetLightLevel rs;
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        int unary = (Integer)interaction.getPersistentDataContainer().getOrDefault(this.plugin.getUnaryKey(), PersistentDataType.INTEGER, (Object)1);
        int setLevel = state + unary;
        if (setLevel > 7) {
            setLevel = 6;
            unary = -1;
        }
        if (setLevel < 0) {
            setLevel = 1;
            unary = 1;
        }
        interaction.getPersistentDataContainer().set(this.plugin.getUnaryKey(), PersistentDataType.INTEGER, (Object)unary);
        UUID uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
        if (uuid != null) {
            ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(uuid);
            new LightLevelModel().setState(display, setLevel, true);
        }
        if ((rs = new ResultSetLightLevel(this.plugin)).fromLocation(interaction.getLocation().toString())) {
            new LightLevelAction(this.plugin).illuminate(setLevel - 1, rs.getControlId(), rs.isPowered(), 50, rs.isPoliceBox(), id, rs.isLightsOn());
            new InteractionStateSaver(this.plugin).write("INTERIOR_LIGHT_LEVEL_SWITCH", setLevel, id);
            this.plugin.getMessenger().announceRepeater(player, "Light level: " + String.valueOf(InteractionResponse.levels.get(setLevel)));
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("secondary", setLevel);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            where.put("type", 50);
            this.plugin.getQueryFactory().doSyncUpdate("controls", set, where);
        }
    }
}

