/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.BeaconToggler;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class ToggleOnOffCommand {
    private final TARDIS plugin;
    private final List<String> was;

    ToggleOnOffCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.was = List.of("announce_repeaters", "auto", "auto_powerup", "auto_siege", "beacon", "build", "close_gui", "console_labels", "dnd", "eps", "farm", "hads", "info", "lock_containers", "minecart", "open_display_door", "regen_block", "renderer", "submarine", "travelbar", "telepathy");
    }

    public boolean toggle(Player player, String[] args) {
        String grammar;
        UUID uuid;
        ResultSetTardisID rsi;
        String pref = args[0];
        if (pref.equals("auto") && !this.plugin.getConfig().getBoolean("allow.autonomous")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AUTO_DISABLED");
            return true;
        }
        if (pref.equals("auto_powerup") && !this.plugin.getConfig().getBoolean("allow.power_down")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN_DISABLED");
            return true;
        }
        if (pref.equals("eps") && !this.plugin.getConfig().getBoolean("allow.emergency_npc")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EP1_DISABLED");
            return true;
        }
        if (pref.equals("hads") && !this.plugin.getConfig().getBoolean("allow.hads")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HADS_DISBALED");
            return true;
        }
        if (pref.equals("lock_containers") && !this.plugin.isWorldGuardOnServer()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WG_DISABLED");
            return true;
        }
        if (pref.equals("lock_containers") && !this.plugin.getUtils().inTARDISWorld(player)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_IN_WORLD");
            return true;
        }
        HashMap<String, Object> setp = new HashMap<String, Object>();
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", player.getUniqueId().toString());
        if (args[1].equalsIgnoreCase("on")) {
            if (args[0].equalsIgnoreCase("lock_containers")) {
                this.plugin.getWorldGuardUtils().lockContainers(player.getWorld(), player.getName());
            } else {
                setp.put(pref + "_on", 1);
                if (pref.equals("beacon") && (rsi = new ResultSetTardisID(this.plugin)).fromUUID((uuid = player.getUniqueId()).toString())) {
                    new BeaconToggler(this.plugin).flickSwitch(uuid, rsi.getTardisId(), true);
                }
            }
            grammar = this.was.contains(pref) ? "PREF_WAS_ON" : "PREF_WERE_ON";
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, grammar, pref);
        }
        if (args[1].equalsIgnoreCase("off")) {
            if (args[0].equalsIgnoreCase("lock_containers")) {
                this.plugin.getWorldGuardUtils().unlockContainers(player.getWorld(), player.getName());
            } else {
                setp.put(pref + "_on", 0);
                if (pref.equals("beacon") && (rsi = new ResultSetTardisID(this.plugin)).fromUUID((uuid = player.getUniqueId()).toString())) {
                    new BeaconToggler(this.plugin).flickSwitch(uuid, rsi.getTardisId(), false);
                }
            }
            grammar = this.was.contains(pref) ? "PREF_WAS_OFF" : "PREF_WERE_OFF";
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, grammar, pref);
        }
        if (!setp.isEmpty()) {
            this.plugin.getQueryFactory().doUpdate("player_prefs", setp, wherep);
        }
        return true;
    }
}

