/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import me.eccentric_nz.TARDIS.chameleon.preset.AdaptivePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.AndesitePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.AngelDownPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.AngelUpPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.ApertureSciencePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.CakePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.CandyCanePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.ChalicePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.ChorusPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.ColumnPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.CreepyPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.DioritePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.DoubleHelixPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.FactoryPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.FencePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.FlowerPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.GazeboPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.GranitePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.GravestonePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.InvisiblePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.JailPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.JunkPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.LampPostPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.LibraryPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.LighthousePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.MineshaftPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.MushroomPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.PartyPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.PeanutButterPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.PineTreePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.PortalPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.PrismarinePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.PunkedPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.RobotPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.RubberDuckPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.SnowmanPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.SubmergedPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.TelephoneBoxPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.ToiletPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.TopsyTurveyPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.TorchPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.VillagePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.WellPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.WindmillPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.YellowSubmarinePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.BoatPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.CavePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.ColdTaigaPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.DesertPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.ExtremeHillsPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.ForestPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.IcePlainsPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.IcePlainsSpikesPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.JunglePreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.MesaPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.NetherPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.PlainsPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.RoofedForestPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.SavannaPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.SwampPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.TaigaPreset;
import me.eccentric_nz.TARDIS.chameleon.preset.biome.TheEndPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.BlockDataRotator;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.RendererPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISCustomPreset;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import org.bukkit.Bukkit;
import org.bukkit.block.data.BlockData;

public class TARDISChameleonPreset {
    public final TARDISCustomPreset custom;
    private final AndesitePreset andesite = new AndesitePreset();
    private final AngelDownPreset angeld = new AngelDownPreset();
    private final AngelUpPreset angelu = new AngelUpPreset();
    private final ApertureSciencePreset aperture = new ApertureSciencePreset();
    private final CakePreset cake = new CakePreset();
    private final CandyCanePreset candy = new CandyCanePreset();
    private final CavePreset cave;
    private final ChalicePreset chalice = new ChalicePreset();
    private final ChorusPreset chorus = new ChorusPreset();
    private final ColumnPreset column = new ColumnPreset();
    private final CreepyPreset creepy = new CreepyPreset();
    private final DesertPreset desert = new DesertPreset();
    private final DioritePreset diorite = new DioritePreset();
    private final DoubleHelixPreset helix;
    private final FactoryPreset factory;
    private final FencePreset fence;
    private final FlowerPreset flower;
    private final GazeboPreset gazebo;
    private final GranitePreset granite;
    private final GravestonePreset gravestone;
    private final InvisiblePreset invisible;
    private final JailPreset jail;
    private final JunglePreset jungle;
    private final JunkPreset junk;
    private final LampPostPreset lamp;
    private final LibraryPreset library;
    private final LighthousePreset lighthouse;
    private final MineshaftPreset mine;
    private final MushroomPreset shroom;
    private final NetherPreset nether;
    private final PartyPreset party;
    private final PeanutButterPreset peanut;
    private final PineTreePreset pine;
    private final PortalPreset portal;
    private final PrismarinePreset prismarine;
    private final PunkedPreset punked;
    private final RobotPreset robot;
    private final RubberDuckPreset duck = new RubberDuckPreset();
    private final SnowmanPreset snowman;
    private final SubmergedPreset submerged;
    private final SwampPreset swamp;
    private final TelephoneBoxPreset telephone;
    private final TheEndPreset theend;
    private final ToiletPreset toilet;
    private final TopsyTurveyPreset topsyturvey;
    private final TorchPreset torch;
    private final VillagePreset village;
    private final WellPreset well;
    private final WindmillPreset windmill;
    private final YellowSubmarinePreset yellow;
    private final AdaptivePreset adaptive;
    private final RendererPreset render;
    private final ExtremeHillsPreset extreme;
    private final ForestPreset forest;
    private final IcePlainsPreset flats;
    private final IcePlainsSpikesPreset spikes;
    private final MesaPreset mesa;
    private final PlainsPreset plains;
    private final RoofedForestPreset roofed;
    private final SavannaPreset savanna;
    private final TaigaPreset taiga;
    private final ColdTaigaPreset cold;
    private final BoatPreset boat;
    private int r;

    public TARDISChameleonPreset() {
        this.factory = new FactoryPreset();
        this.fence = new FencePreset();
        this.flower = new FlowerPreset();
        this.gazebo = new GazeboPreset();
        this.granite = new GranitePreset();
        this.gravestone = new GravestonePreset();
        this.helix = new DoubleHelixPreset();
        this.invisible = new InvisiblePreset();
        this.jail = new JailPreset();
        this.jungle = new JunglePreset();
        this.junk = new JunkPreset();
        this.lamp = new LampPostPreset();
        this.library = new LibraryPreset();
        this.lighthouse = new LighthousePreset();
        this.mine = new MineshaftPreset();
        this.nether = new NetherPreset();
        this.party = new PartyPreset();
        this.peanut = new PeanutButterPreset();
        this.pine = new PineTreePreset();
        this.portal = new PortalPreset();
        this.prismarine = new PrismarinePreset();
        this.punked = new PunkedPreset();
        this.robot = new RobotPreset();
        this.shroom = new MushroomPreset();
        this.snowman = new SnowmanPreset();
        this.submerged = new SubmergedPreset();
        this.swamp = new SwampPreset();
        this.telephone = new TelephoneBoxPreset();
        this.theend = new TheEndPreset();
        this.toilet = new ToiletPreset();
        this.topsyturvey = new TopsyTurveyPreset();
        this.torch = new TorchPreset();
        this.village = new VillagePreset();
        this.well = new WellPreset();
        this.windmill = new WindmillPreset();
        this.yellow = new YellowSubmarinePreset();
        this.custom = new TARDISCustomPreset();
        this.adaptive = new AdaptivePreset();
        this.render = new RendererPreset();
        this.extreme = new ExtremeHillsPreset();
        this.forest = new ForestPreset();
        this.flats = new IcePlainsPreset();
        this.spikes = new IcePlainsSpikesPreset();
        this.mesa = new MesaPreset();
        this.plains = new PlainsPreset();
        this.roofed = new RoofedForestPreset();
        this.savanna = new SavannaPreset();
        this.taiga = new TaigaPreset();
        this.cold = new ColdTaigaPreset();
        this.boat = new BoatPreset();
        this.cave = new CavePreset();
    }

    public static ChameleonColumn buildTARDISChameleonColumn(COMPASS d, String[][] strings) {
        BlockData[][] blockDataArr = TARDISChameleonPreset.getBlockDataFromArray(strings);
        ChameleonColumn tcc = d.equals((Object)COMPASS.EAST) ? new ChameleonColumn(blockDataArr) : new ChameleonColumn(TARDISChameleonPreset.convertData(TARDISChameleonPreset.rotate2DArray(blockDataArr, d), d));
        return tcc;
    }

    public static ChameleonColumn buildTARDISChameleonColumn(COMPASS d, String json) {
        BlockData[][] blockDataArr = TARDISChameleonPreset.getStringArrayFromJSON(json);
        ChameleonColumn tcc = d.equals((Object)COMPASS.EAST) ? new ChameleonColumn(blockDataArr) : new ChameleonColumn(TARDISChameleonPreset.convertData(TARDISChameleonPreset.rotate2DArray(blockDataArr, d), d));
        return tcc;
    }

    public static ChameleonColumn buildTARDISChameleonColumn(COMPASS d, JsonArray json) {
        BlockData[][] blockDataArr = TARDISChameleonPreset.getStringArrayFromJSON(json);
        ChameleonColumn tcc = d.equals((Object)COMPASS.EAST) ? new ChameleonColumn(blockDataArr) : new ChameleonColumn(TARDISChameleonPreset.convertData(TARDISChameleonPreset.rotate2DArray(blockDataArr, d), d));
        return tcc;
    }

    private static BlockData[][] getBlockDataFromArray(String[][] arr) {
        BlockData[][] preset = new BlockData[10][4];
        for (int col = 0; col < 10; ++col) {
            for (int block = 0; block < 4; ++block) {
                preset[col][block] = Bukkit.createBlockData((String)arr[col][block]);
            }
        }
        return preset;
    }

    private static BlockData[][] getStringArrayFromJSON(String js) {
        BlockData[][] preset = new BlockData[10][4];
        JsonArray json = JsonParser.parseString((String)js).getAsJsonArray();
        for (int col = 0; col < 10; ++col) {
            JsonArray jsoncol = json.get(col).getAsJsonArray();
            for (int block = 0; block < 4; ++block) {
                preset[col][block] = Bukkit.createBlockData((String)jsoncol.get(block).getAsString());
            }
        }
        return preset;
    }

    private static BlockData[][] getStringArrayFromJSON(JsonArray json) {
        BlockData[][] preset = new BlockData[10][4];
        for (int col = 0; col < 10; ++col) {
            JsonArray jsoncol = json.get(col).getAsJsonArray();
            for (int block = 0; block < 4; ++block) {
                preset[col][block] = Bukkit.createBlockData((String)jsoncol.get(block).getAsString());
            }
        }
        return preset;
    }

    private static BlockData[][] rotate2DArray(BlockData[][] arr, COMPASS d) {
        BlockData[] zero = arr[0];
        BlockData[] one = arr[1];
        BlockData[] two = arr[2];
        BlockData[] three = arr[3];
        BlockData[] four = arr[4];
        BlockData[] five = arr[5];
        BlockData[] six = arr[6];
        BlockData[] seven = arr[7];
        switch (d) {
            case NORTH: {
                arr[0] = two;
                arr[1] = three;
                arr[2] = four;
                arr[3] = five;
                arr[4] = six;
                arr[5] = seven;
                arr[6] = zero;
                arr[7] = one;
                return arr;
            }
            case WEST: {
                arr[0] = four;
                arr[1] = five;
                arr[2] = six;
                arr[3] = seven;
                arr[4] = zero;
                arr[5] = one;
                arr[6] = two;
                arr[7] = three;
                return arr;
            }
        }
        arr[0] = six;
        arr[1] = seven;
        arr[2] = zero;
        arr[3] = one;
        arr[4] = two;
        arr[5] = three;
        arr[6] = four;
        arr[7] = five;
        return arr;
    }

    private static BlockData[][] convertData(BlockData[][] data, COMPASS d) {
        for (int col = 0; col < 10; ++col) {
            for (int block = 0; block < 4; ++block) {
                data[col][block] = BlockDataRotator.rotate(data[col][block], d);
            }
        }
        return data;
    }

    public void makePresets() {
        this.andesite.makePresets();
        this.angeld.makePresets();
        this.angelu.makePresets();
        this.aperture.makePresets();
        this.cake.makePresets();
        this.candy.makePresets();
        this.chalice.makePresets();
        this.chorus.makePresets();
        this.column.makePresets();
        this.creepy.makePresets();
        this.desert.makePresets();
        this.diorite.makePresets();
        this.duck.makePresets();
        this.factory.makePresets();
        this.fence.makePresets();
        this.flower.makePresets();
        this.gazebo.makePresets();
        this.granite.makePresets();
        this.gravestone.makePresets();
        this.helix.makePresets();
        this.invisible.makePresets();
        this.jail.makePresets();
        this.jungle.makePresets();
        this.junk.makePresets();
        this.lamp.makePresets();
        this.library.makePresets();
        this.lighthouse.makePresets();
        this.mine.makePresets();
        this.nether.makePresets();
        this.party.makePresets();
        this.peanut.makePresets();
        this.pine.makePresets();
        this.portal.makePresets();
        this.prismarine.makePresets();
        this.punked.makePresets();
        this.robot.makePresets();
        this.shroom.makePresets();
        this.snowman.makePresets();
        this.submerged.makePresets();
        this.swamp.makePresets();
        this.telephone.makePresets();
        this.theend.makePresets();
        this.toilet.makePresets();
        this.topsyturvey.makePresets();
        this.torch.makePresets();
        this.village.makePresets();
        this.well.makePresets();
        this.windmill.makePresets();
        this.yellow.makePresets();
        this.custom.makePresets();
        this.adaptive.makePresets();
        this.render.makePresets();
        this.extreme.makePresets();
        this.forest.makePresets();
        this.flats.makePresets();
        this.spikes.makePresets();
        this.mesa.makePresets();
        this.plains.makePresets();
        this.roofed.makePresets();
        this.savanna.makePresets();
        this.taiga.makePresets();
        this.cold.makePresets();
        this.boat.makePresets();
        this.cave.makePresets();
    }

    public ChameleonColumn getColumn(ChameleonPreset p, COMPASS d) {
        switch (p) {
            case ANDESITE: {
                return this.andesite.getBlueprint().get((Object)d);
            }
            case ANGEL: {
                if (this.r == 0) {
                    return this.angelu.getBlueprint().get((Object)d);
                }
                return this.angeld.getBlueprint().get((Object)d);
            }
            case APPERTURE: {
                return this.aperture.getBlueprint().get((Object)d);
            }
            case CAKE: {
                return this.cake.getBlueprint().get((Object)d);
            }
            case CANDY: {
                return this.candy.getBlueprint().get((Object)d);
            }
            case CHALICE: {
                return this.chalice.getBlueprint().get((Object)d);
            }
            case CHORUS: {
                return this.chorus.getBlueprint().get((Object)d);
            }
            case CREEPY: {
                return this.creepy.getBlueprint().get((Object)d);
            }
            case DESERT: {
                return this.desert.getBlueprint().get((Object)d);
            }
            case DIORITE: {
                return this.diorite.getBlueprint().get((Object)d);
            }
            case DUCK: {
                return this.duck.getBlueprint().get((Object)d);
            }
            case FACTORY: {
                return this.factory.getBlueprint().get((Object)d);
            }
            case FENCE: {
                return this.fence.getBlueprint().get((Object)d);
            }
            case FLOWER: {
                return this.flower.getBlueprint().get((Object)d);
            }
            case GAZEBO: {
                return this.gazebo.getBlueprint().get((Object)d);
            }
            case GRANITE: {
                return this.granite.getBlueprint().get((Object)d);
            }
            case GRAVESTONE: {
                return this.gravestone.getBlueprint().get((Object)d);
            }
            case HELIX: {
                return this.helix.getBlueprint().get((Object)d);
            }
            case INVISIBLE: {
                return this.invisible.getBlueprint().get((Object)d);
            }
            case JAIL: {
                return this.jail.getBlueprint().get((Object)d);
            }
            case JUNGLE: {
                return this.jungle.getBlueprint().get((Object)d);
            }
            case JUNK_MODE: {
                return this.junk.getBlueprint().get((Object)d);
            }
            case LAMP: {
                return this.lamp.getBlueprint().get((Object)d);
            }
            case LIBRARY: {
                return this.library.getBlueprint().get((Object)d);
            }
            case LIGHTHOUSE: {
                return this.lighthouse.getBlueprint().get((Object)d);
            }
            case MINESHAFT: {
                return this.mine.getBlueprint().get((Object)d);
            }
            case NETHER: {
                return this.nether.getBlueprint().get((Object)d);
            }
            case PARTY: {
                return this.party.getBlueprint().get((Object)d);
            }
            case PEANUT: {
                return this.peanut.getBlueprint().get((Object)d);
            }
            case PINE: {
                return this.pine.getBlueprint().get((Object)d);
            }
            case PORTAL: {
                return this.portal.getBlueprint().get((Object)d);
            }
            case PRISMARINE: {
                return this.prismarine.getBlueprint().get((Object)d);
            }
            case PUNKED: {
                return this.punked.getBlueprint().get((Object)d);
            }
            case RENDER: {
                return this.render.getBlueprint().get((Object)d);
            }
            case ROBOT: {
                return this.robot.getBlueprint().get((Object)d);
            }
            case SHROOM: {
                return this.shroom.getBlueprint().get((Object)d);
            }
            case SNOWMAN: {
                return this.snowman.getBlueprint().get((Object)d);
            }
            case STONE: {
                return this.column.getBlueprint().get((Object)d);
            }
            case SUBMERGED: {
                return this.submerged.getBlueprint().get((Object)d);
            }
            case SWAMP: {
                return this.swamp.getBlueprint().get((Object)d);
            }
            case TELEPHONE: {
                return this.telephone.getBlueprint().get((Object)d);
            }
            case THEEND: {
                return this.theend.getBlueprint().get((Object)d);
            }
            case TOILET: {
                return this.toilet.getBlueprint().get((Object)d);
            }
            case TOPSYTURVEY: {
                return this.topsyturvey.getBlueprint().get((Object)d);
            }
            case TORCH: {
                return this.torch.getBlueprint().get((Object)d);
            }
            case VILLAGE: {
                return this.village.getBlueprint().get((Object)d);
            }
            case WELL: {
                return this.well.getBlueprint().get((Object)d);
            }
            case WINDMILL: {
                return this.windmill.getBlueprint().get((Object)d);
            }
            case YELLOW: {
                return this.yellow.getBlueprint().get((Object)d);
            }
            case EXTREME_HILLS: {
                return this.extreme.getBlueprint().get((Object)d);
            }
            case FOREST: {
                return this.forest.getBlueprint().get((Object)d);
            }
            case ICE_FLATS: {
                return this.flats.getBlueprint().get((Object)d);
            }
            case ICE_SPIKES: {
                return this.spikes.getBlueprint().get((Object)d);
            }
            case MESA: {
                return this.mesa.getBlueprint().get((Object)d);
            }
            case PLAINS: {
                return this.plains.getBlueprint().get((Object)d);
            }
            case ROOFED_FOREST: {
                return this.roofed.getBlueprint().get((Object)d);
            }
            case SAVANNA: {
                return this.savanna.getBlueprint().get((Object)d);
            }
            case TAIGA: {
                return this.taiga.getBlueprint().get((Object)d);
            }
            case COLD_TAIGA: {
                return this.cold.getBlueprint().get((Object)d);
            }
            case BOAT: {
                return this.boat.getBlueprint().get((Object)d);
            }
            case CAVE: {
                return this.cave.getBlueprint().get((Object)d);
            }
        }
        return this.adaptive.getBlueprint().get((Object)d);
    }

    public ChameleonColumn getGlass(ChameleonPreset p, COMPASS d) {
        switch (p) {
            case ANDESITE: {
                return this.andesite.getGlass().get((Object)d);
            }
            case ANGEL: {
                if (this.r == 0) {
                    return this.angelu.getGlass().get((Object)d);
                }
                return this.angeld.getGlass().get((Object)d);
            }
            case APPERTURE: {
                return this.aperture.getGlass().get((Object)d);
            }
            case CAKE: {
                return this.cake.getGlass().get((Object)d);
            }
            case CANDY: {
                return this.candy.getGlass().get((Object)d);
            }
            case CHALICE: {
                return this.chalice.getGlass().get((Object)d);
            }
            case CHORUS: {
                return this.chorus.getGlass().get((Object)d);
            }
            case CREEPY: {
                return this.creepy.getGlass().get((Object)d);
            }
            case DESERT: {
                return this.desert.getGlass().get((Object)d);
            }
            case DIORITE: {
                return this.diorite.getGlass().get((Object)d);
            }
            case DUCK: {
                return this.duck.getGlass().get((Object)d);
            }
            case FACTORY: {
                return this.factory.getGlass().get((Object)d);
            }
            case FENCE: {
                return this.fence.getGlass().get((Object)d);
            }
            case FLOWER: {
                return this.flower.getGlass().get((Object)d);
            }
            case GAZEBO: {
                return this.gazebo.getGlass().get((Object)d);
            }
            case GRANITE: {
                return this.granite.getGlass().get((Object)d);
            }
            case GRAVESTONE: {
                return this.gravestone.getGlass().get((Object)d);
            }
            case HELIX: {
                return this.helix.getGlass().get((Object)d);
            }
            case INVISIBLE: {
                return this.invisible.getGlass().get((Object)d);
            }
            case JAIL: {
                return this.jail.getGlass().get((Object)d);
            }
            case JUNGLE: {
                return this.jungle.getGlass().get((Object)d);
            }
            case JUNK_MODE: {
                return this.junk.getGlass().get((Object)d);
            }
            case LAMP: {
                return this.lamp.getGlass().get((Object)d);
            }
            case LIBRARY: {
                return this.library.getGlass().get((Object)d);
            }
            case LIGHTHOUSE: {
                return this.lighthouse.getGlass().get((Object)d);
            }
            case MINESHAFT: {
                return this.mine.getGlass().get((Object)d);
            }
            case NETHER: {
                return this.nether.getGlass().get((Object)d);
            }
            case PARTY: {
                return this.party.getGlass().get((Object)d);
            }
            case PEANUT: {
                return this.peanut.getGlass().get((Object)d);
            }
            case PINE: {
                return this.pine.getGlass().get((Object)d);
            }
            case PORTAL: {
                return this.portal.getGlass().get((Object)d);
            }
            case PRISMARINE: {
                return this.prismarine.getGlass().get((Object)d);
            }
            case PUNKED: {
                return this.punked.getGlass().get((Object)d);
            }
            case RENDER: {
                return this.render.getGlass().get((Object)d);
            }
            case ROBOT: {
                return this.robot.getGlass().get((Object)d);
            }
            case SHROOM: {
                return this.shroom.getGlass().get((Object)d);
            }
            case SNOWMAN: {
                return this.snowman.getGlass().get((Object)d);
            }
            case STONE: {
                return this.column.getGlass().get((Object)d);
            }
            case SUBMERGED: {
                return this.submerged.getGlass().get((Object)d);
            }
            case SWAMP: {
                return this.swamp.getGlass().get((Object)d);
            }
            case TELEPHONE: {
                return this.telephone.getGlass().get((Object)d);
            }
            case THEEND: {
                return this.theend.getGlass().get((Object)d);
            }
            case TOILET: {
                return this.toilet.getGlass().get((Object)d);
            }
            case TOPSYTURVEY: {
                return this.topsyturvey.getGlass().get((Object)d);
            }
            case TORCH: {
                return this.torch.getGlass().get((Object)d);
            }
            case VILLAGE: {
                return this.village.getGlass().get((Object)d);
            }
            case WELL: {
                return this.well.getGlass().get((Object)d);
            }
            case WINDMILL: {
                return this.windmill.getGlass().get((Object)d);
            }
            case YELLOW: {
                return this.yellow.getGlass().get((Object)d);
            }
            case EXTREME_HILLS: {
                return this.extreme.getGlass().get((Object)d);
            }
            case FOREST: {
                return this.forest.getGlass().get((Object)d);
            }
            case ICE_FLATS: {
                return this.flats.getGlass().get((Object)d);
            }
            case ICE_SPIKES: {
                return this.spikes.getGlass().get((Object)d);
            }
            case MESA: {
                return this.mesa.getGlass().get((Object)d);
            }
            case PLAINS: {
                return this.plains.getGlass().get((Object)d);
            }
            case ROOFED_FOREST: {
                return this.roofed.getGlass().get((Object)d);
            }
            case SAVANNA: {
                return this.savanna.getGlass().get((Object)d);
            }
            case TAIGA: {
                return this.taiga.getGlass().get((Object)d);
            }
            case COLD_TAIGA: {
                return this.cold.getGlass().get((Object)d);
            }
            case BOAT: {
                return this.boat.getGlass().get((Object)d);
            }
            case CAVE: {
                return this.cave.getGlass().get((Object)d);
            }
        }
        return this.adaptive.getGlass().get((Object)d);
    }

    public ChameleonColumn getStained(ChameleonPreset p, COMPASS d) {
        switch (p) {
            case ANDESITE: {
                return this.andesite.getStained().get((Object)d);
            }
            case ANGEL: {
                if (this.r == 0) {
                    return this.angelu.getStained().get((Object)d);
                }
                return this.angeld.getStained().get((Object)d);
            }
            case APPERTURE: {
                return this.aperture.getStained().get((Object)d);
            }
            case CAKE: {
                return this.cake.getStained().get((Object)d);
            }
            case CANDY: {
                return this.candy.getStained().get((Object)d);
            }
            case CHALICE: {
                return this.chalice.getStained().get((Object)d);
            }
            case CHORUS: {
                return this.chorus.getStained().get((Object)d);
            }
            case CREEPY: {
                return this.creepy.getStained().get((Object)d);
            }
            case DESERT: {
                return this.desert.getStained().get((Object)d);
            }
            case DIORITE: {
                return this.diorite.getStained().get((Object)d);
            }
            case DUCK: {
                return this.duck.getStained().get((Object)d);
            }
            case FACTORY: {
                return this.factory.getStained().get((Object)d);
            }
            case FENCE: {
                return this.fence.getStained().get((Object)d);
            }
            case FLOWER: {
                return this.flower.getStained().get((Object)d);
            }
            case GAZEBO: {
                return this.gazebo.getStained().get((Object)d);
            }
            case GRANITE: {
                return this.granite.getStained().get((Object)d);
            }
            case GRAVESTONE: {
                return this.gravestone.getStained().get((Object)d);
            }
            case HELIX: {
                return this.helix.getStained().get((Object)d);
            }
            case INVISIBLE: {
                return this.invisible.getStained().get((Object)d);
            }
            case JAIL: {
                return this.jail.getStained().get((Object)d);
            }
            case JUNGLE: {
                return this.jungle.getStained().get((Object)d);
            }
            case JUNK_MODE: {
                return this.junk.getStained().get((Object)d);
            }
            case LAMP: {
                return this.lamp.getStained().get((Object)d);
            }
            case LIBRARY: {
                return this.library.getStained().get((Object)d);
            }
            case LIGHTHOUSE: {
                return this.lighthouse.getStained().get((Object)d);
            }
            case MINESHAFT: {
                return this.mine.getStained().get((Object)d);
            }
            case NETHER: {
                return this.nether.getStained().get((Object)d);
            }
            case PARTY: {
                return this.party.getStained().get((Object)d);
            }
            case PEANUT: {
                return this.peanut.getStained().get((Object)d);
            }
            case PINE: {
                return this.pine.getStained().get((Object)d);
            }
            case PORTAL: {
                return this.portal.getStained().get((Object)d);
            }
            case PRISMARINE: {
                return this.prismarine.getStained().get((Object)d);
            }
            case PUNKED: {
                return this.punked.getStained().get((Object)d);
            }
            case RENDER: {
                return this.render.getStained().get((Object)d);
            }
            case ROBOT: {
                return this.robot.getStained().get((Object)d);
            }
            case SHROOM: {
                return this.shroom.getStained().get((Object)d);
            }
            case SNOWMAN: {
                return this.snowman.getStained().get((Object)d);
            }
            case STONE: {
                return this.column.getStained().get((Object)d);
            }
            case SUBMERGED: {
                return this.submerged.getStained().get((Object)d);
            }
            case SWAMP: {
                return this.swamp.getStained().get((Object)d);
            }
            case TELEPHONE: {
                return this.telephone.getStained().get((Object)d);
            }
            case THEEND: {
                return this.theend.getStained().get((Object)d);
            }
            case TOILET: {
                return this.toilet.getStained().get((Object)d);
            }
            case TOPSYTURVEY: {
                return this.topsyturvey.getStained().get((Object)d);
            }
            case TORCH: {
                return this.torch.getStained().get((Object)d);
            }
            case VILLAGE: {
                return this.village.getStained().get((Object)d);
            }
            case WELL: {
                return this.well.getStained().get((Object)d);
            }
            case WINDMILL: {
                return this.windmill.getStained().get((Object)d);
            }
            case YELLOW: {
                return this.yellow.getStained().get((Object)d);
            }
            case EXTREME_HILLS: {
                return this.extreme.getStained().get((Object)d);
            }
            case FOREST: {
                return this.forest.getStained().get((Object)d);
            }
            case ICE_FLATS: {
                return this.flats.getStained().get((Object)d);
            }
            case ICE_SPIKES: {
                return this.spikes.getStained().get((Object)d);
            }
            case MESA: {
                return this.mesa.getStained().get((Object)d);
            }
            case PLAINS: {
                return this.plains.getStained().get((Object)d);
            }
            case ROOFED_FOREST: {
                return this.roofed.getStained().get((Object)d);
            }
            case SAVANNA: {
                return this.savanna.getStained().get((Object)d);
            }
            case TAIGA: {
                return this.taiga.getStained().get((Object)d);
            }
            case COLD_TAIGA: {
                return this.cold.getStained().get((Object)d);
            }
            case BOAT: {
                return this.boat.getStained().get((Object)d);
            }
            case CAVE: {
                return this.cave.getStained().get((Object)d);
            }
        }
        return this.adaptive.getStained().get((Object)d);
    }

    public void setR(int r) {
        this.r = r;
    }
}

