/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.interior;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.ARS.ARSMethods;
import me.eccentric_nz.TARDIS.ARS.GrowSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTIPS;
import me.eccentric_nz.TARDIS.desktop.ChunkUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.move.DoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TARDISInteriorPostioning {
    private final TARDIS plugin;

    public TARDISInteriorPostioning(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static int getTIPSSlot(Location location) {
        int px = location.getBlockX();
        int pz = location.getBlockZ();
        int col = px / 1024;
        int row = pz / 1024;
        return col * 20 + row;
    }

    public int getFreeSlot() {
        int limit = this.plugin.getConfig().getInt("creation.tips_limit");
        int slot = -1;
        if (this.plugin.getConfig().getString("creation.tips_next", "HIGHEST").equalsIgnoreCase("FREE")) {
            for (int i = 0; i < limit; ++i) {
                if (TARDISBuilderInstanceKeeper.getTipsSlots().contains(i)) continue;
                slot = i;
                break;
            }
        } else {
            slot = new ResultSetTIPS(this.plugin).getHightestSlot() + 1;
        }
        return slot;
    }

    public TIPSData getTIPSData(int slot) {
        TIPSData data = new TIPSData();
        int factorX = 0;
        int factorZ = 0;
        int subtract = 0;
        if (slot > 399 && slot < 800) {
            factorX = 20480;
            subtract = 400;
        }
        if (slot > 799 && slot < 1200) {
            factorZ = 20480;
            subtract = 800;
        }
        if (slot > 1199 && slot < 1600) {
            factorX = 20480;
            factorZ = 20480;
            subtract = 1200;
        }
        int row = (slot - subtract) / 20;
        int col = (slot - subtract) % 20;
        data.setMinX(row * 1024 + factorX);
        data.setCentreX(row * 1024 + 496 + factorX);
        data.setMaxX(row * 1024 + 1023 + factorX);
        data.setMinZ(col * 1024 + factorZ);
        data.setCentreZ(col * 1024 + 496 + factorZ);
        data.setMaxZ(col * 1024 + 1023 + factorZ);
        data.setSlot(slot);
        return data;
    }

    public TIPSData getTIPSJunkData(int slot) {
        if (slot == -999) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", -21);
            this.plugin.getQueryFactory().doDelete("transmats", where);
            return this.getTIPSData(-21);
        }
        return this.getTIPSData(-99);
    }

    public void reclaimChunks(World w, int id, Schematic s) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetARS rs = new ResultSetARS(this.plugin, where);
        if (rs.resultSet()) {
            TARDISDoorLocation dl = DoorListener.getDoor(0, id);
            Location exitLocation = dl.getL();
            String[][][] json = ARSMethods.getGridFromJSON(rs.getJson());
            Chunk c = this.plugin.getLocationUtils().getTARDISChunk(id);
            List<Chunk> chunks = ChunkUtils.getConsoleChunks(c, s);
            chunks.forEach(u -> {
                for (Entity e : u.getEntities()) {
                    this.removeEntity(e, exitLocation);
                }
                if (s.getPermission().equals("mechanical") || s.getPermission().equals("cursed")) {
                    int cx = u.getX() * 16;
                    int cz = u.getZ() * 16;
                    for (int y = 62; y < 64; ++y) {
                        for (int col = cx; col < cx + 16; ++col) {
                            for (int row = cz; row < cz + 16; ++row) {
                                w.getBlockAt(row, y, col).setBlockData(TARDISConstants.AIR);
                            }
                        }
                    }
                }
            });
            for (int l = 0; l < 3; ++l) {
                for (int x = 0; x < 9; ++x) {
                    for (int z = 0; z < 9; ++z) {
                        if (json[l][x][z].equalsIgnoreCase("STONE")) continue;
                        GrowSlot slot = new GrowSlot();
                        slot.setChunk(c);
                        slot.setY(l);
                        slot.setX(x);
                        slot.setZ(z);
                        Chunk tipsChunk = w.getBlockAt(slot.getX(), slot.getY(), slot.getZ()).getChunk();
                        for (Entity e : tipsChunk.getEntities()) {
                            this.removeEntity(e, exitLocation);
                        }
                        for (int y = 0; y < 16; ++y) {
                            for (int col = 0; col < 16; ++col) {
                                for (int row = 0; row < 16; ++row) {
                                    w.getBlockAt(slot.getX() + row, slot.getY() + y, slot.getZ() + col).setBlockData(TARDISConstants.AIR);
                                }
                            }
                        }
                        for (Entity e : tipsChunk.getEntities()) {
                            e.remove();
                        }
                    }
                }
            }
            chunks.forEach(u -> {
                for (Entity e : u.getEntities()) {
                    e.remove();
                }
            });
        }
    }

    private void removeEntity(Entity entity, Location exit) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.teleportPlayerToExit(p, exit);
        } else {
            entity.remove();
        }
    }

    private void teleportPlayerToExit(Player player, Location exit) {
        this.plugin.getGeneralKeeper().getDoorListener().movePlayer(player, exit, true, player.getWorld(), false, 0, true, true);
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", player.getUniqueId().toString());
        this.plugin.getQueryFactory().doDelete("travellers", wheret);
    }

    public void reclaimZeroChunk(World w, TIPSData data) {
        Location l = new Location(w, (double)data.getMinX(), 0.0, (double)data.getMinZ());
        Chunk chunk = w.getChunkAt(l);
        Block block = chunk.getBlock(0, 0, 0);
        int sx = block.getX();
        int sz = block.getZ();
        for (int y = 64; y < 80; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int cx = sx + x;
                    int cz = sz + z;
                    w.getBlockAt(cx, y, cz).setBlockData(TARDISConstants.AIR);
                }
            }
        }
    }
}

