/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import me.eccentric_nz.TARDIS.ARS.ARSConverter;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.construct.ConstructsConverter;
import me.eccentric_nz.TARDIS.database.converters.BindConverter;
import me.eccentric_nz.TARDIS.database.converters.ControlsConverter;
import me.eccentric_nz.TARDIS.database.converters.FarmingConverter;
import me.eccentric_nz.TARDIS.database.converters.GrassConverter;
import me.eccentric_nz.TARDIS.database.converters.LegacyConverter;
import me.eccentric_nz.TARDIS.database.converters.MaterialIDConverter;
import me.eccentric_nz.TARDIS.database.converters.SaveIconUpdate;
import me.eccentric_nz.TARDIS.database.converters.WallConverter;
import me.eccentric_nz.TARDIS.database.converters.WallSignConverter;
import me.eccentric_nz.TARDIS.doors.InteractionDoorUpdater;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.AllInOneConfigConverter;
import me.eccentric_nz.TARDIS.rooms.eye.EyePopulator;

public class TARDISConversions {
    private final TARDIS plugin;
    private int conversions = 0;

    public TARDISConversions(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void convert() {
        if (!(this.plugin.getConfig().getBoolean("conversions.condenser_materials") && this.plugin.getConfig().getBoolean("conversions.player_prefs_materials") && this.plugin.getConfig().getBoolean("conversions.block_materials"))) {
            MaterialIDConverter tmic = new MaterialIDConverter(this.plugin);
            tmic.checkCondenserData();
            tmic.checkPlayerPrefsData();
            tmic.checkBlockData();
            new FarmingConverter(this.plugin).update();
        }
        if (!this.plugin.getConfig().getBoolean("conversions.block_wall_signs")) {
            new WallSignConverter(this.plugin).convertSignBlocks();
            this.plugin.getConfig().set("conversions.block_wall_signs", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.short_grass")) {
            new GrassConverter(this.plugin).checkBlockData();
            this.plugin.getConfig().set("conversions.short_grass", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.eyes")) {
            new EyePopulator(this.plugin).insert();
            this.plugin.getConfig().set("conversions.eyes", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.ars_materials")) {
            new ARSConverter(this.plugin).convertARS();
            this.plugin.getConfig().set("conversions.ars_materials", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.constructs")) {
            new ConstructsConverter(this.plugin).convertConstructs();
            this.plugin.getConfig().set("conversions.constructs", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.controls")) {
            new ControlsConverter(this.plugin).update();
            this.plugin.getConfig().set("conversions.controls", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.bind")) {
            new BindConverter(this.plugin).update();
            this.plugin.getConfig().set("conversions.bind", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.icons")) {
            new SaveIconUpdate(this.plugin).addIcons();
            this.plugin.getConfig().set("conversions.icons", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.archive_wall_data")) {
            new WallConverter(this.plugin).processArchives();
            this.plugin.getConfig().set("conversions.archive_wall_data", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.legacy_default")) {
            new LegacyConverter(this.plugin).setOriginal();
            this.plugin.getConfig().set("conversions.legacy_default", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.all_in_one.helper") && new AllInOneConfigConverter(this.plugin).transferConfig(TardisModule.HELPER)) {
            this.plugin.getConfig().set("conversions.all_in_one.helper", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.interior_door_id") && new InteractionDoorUpdater(this.plugin).addIds()) {
            this.plugin.getConfig().set("conversions.interior_door_id", (Object)true);
            ++this.conversions;
        }
        if (this.conversions > 0) {
            this.plugin.saveConfig();
        }
    }
}

