/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.constructor;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.HandlesVariant;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardischemistry.constructor.ConstructorInventory;
import me.eccentric_nz.tardischemistry.element.Element;
import me.eccentric_nz.tardischemistry.element.ElementBuilder;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConstructorGUIListener
extends TARDISMenuListener {
    public ConstructorGUIListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onElementMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ConstructorInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("ConstructorGUIListener");
                event.setCancelled(true);
            }
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 5: {
                event.setCancelled(true);
                int pminus = this.getCount(view, 0);
                if (pminus <= 0) break;
                this.setCount(view, pminus - 1, 0);
                this.setElement(view);
                break;
            }
            case 6: {
                event.setCancelled(true);
                int pplus = this.getCount(view, 0);
                if (pplus >= 118) break;
                this.setCount(view, pplus + 1, 0);
                this.setElement(view);
                break;
            }
            case 14: {
                event.setCancelled(true);
                int nminus = this.getCount(view, 9);
                if (nminus <= 0) break;
                this.setCount(view, nminus - 1, 9);
                this.setElement(view);
                break;
            }
            case 15: {
                event.setCancelled(true);
                int nplus = this.getCount(view, 9);
                if (nplus >= 177) break;
                this.setCount(view, nplus + 1, 9);
                this.setElement(view);
                break;
            }
            case 23: {
                event.setCancelled(true);
                int eminus = this.getCount(view, 18);
                if (eminus <= 0) break;
                this.setCount(view, eminus - 1, 18);
                this.setElement(view);
                break;
            }
            case 24: {
                event.setCancelled(true);
                int eplus = this.getCount(view, 18);
                if (eplus >= 118) break;
                this.setCount(view, eplus + 1, 18);
                this.setElement(view);
                break;
            }
            case 17: {
                event.setCancelled(true);
                if (view.getItem(17) == null) {
                    return;
                }
                ItemStack choice = view.getItem(17).clone();
                choice.setAmount(event.getClick().equals((Object)ClickType.SHIFT_LEFT) ? 64 : 1);
                p.getInventory().addItem(new ItemStack[]{choice});
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private int getCount(InventoryView view, int offset) {
        ItemStack hundreds;
        int tenInt = 0;
        int hundredInt = 0;
        ItemStack ones = view.getItem(3 + offset);
        ItemMeta oneMeta = ones.getItemMeta();
        int oneInt = ComponentUtils.parseInt(oneMeta.displayName());
        ItemStack tens = view.getItem(2 + offset);
        if (tens != null) {
            ItemMeta tenMeta = tens.getItemMeta();
            tenInt = ComponentUtils.parseInt(tenMeta.displayName()) * 10;
        }
        if ((hundreds = view.getItem(1 + offset)) != null) {
            ItemMeta hundredMeta = hundreds.getItemMeta();
            hundredInt = ComponentUtils.parseInt(hundredMeta.displayName()) * 100;
        }
        return oneInt + tenInt + hundredInt;
    }

    private void setCount(InventoryView view, int amount, int offset) {
        int oneInt = amount % 10;
        int tenInt = amount / 10 % 10;
        int hundredInt = amount / 100 % 10;
        ItemStack ones = view.getItem(3 + offset);
        ItemMeta oneMeta = ones.getItemMeta();
        oneMeta.displayName((Component)Component.text((int)oneInt));
        oneMeta.setItemModel(HandlesVariant.values()[25 + oneInt].getKey());
        ones.setItemMeta(oneMeta);
        ItemStack tens = view.getItem(2 + offset);
        if (tenInt > 0 || tenInt == 0 && hundredInt > 0) {
            if (tens == null) {
                tens = ItemStack.of((Material)Material.PAPER, (int)1);
            }
            ItemMeta tenMeta = tens.getItemMeta();
            tenMeta.displayName((Component)Component.text((int)tenInt));
            tenMeta.setItemModel(HandlesVariant.values()[25 + tenInt].getKey());
            tens.setItemMeta(tenMeta);
            view.setItem(2 + offset, tens);
        } else {
            view.setItem(2 + offset, null);
        }
        ItemStack hundreds = view.getItem(1 + offset);
        if (hundredInt > 0) {
            if (hundreds == null) {
                hundreds = ItemStack.of((Material)Material.PAPER, (int)1);
            }
            ItemMeta hundredMeta = hundreds.getItemMeta();
            hundredMeta.displayName((Component)Component.text((int)hundredInt));
            hundredMeta.setItemModel(HandlesVariant.values()[25 + hundredInt].getKey());
            hundreds.setItemMeta(hundredMeta);
            view.setItem(1 + offset, hundreds);
        } else {
            view.setItem(1 + offset, null);
        }
    }

    private void setElement(InventoryView view) {
        int protons = this.getCount(view, 0);
        int neutrons = this.getCount(view, 9);
        int electrons = this.getCount(view, 18);
        for (Element element : Element.values()) {
            if (protons != element.getAtomicNumber() || neutrons != element.getNeutrons() || electrons != element.getAtomicNumber()) continue;
            ItemStack is = ElementBuilder.getElement(element);
            view.setItem(17, is);
            return;
        }
        view.setItem(17, null);
    }
}

