/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.hads;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.hads.HostileDispersal;
import me.eccentric_nz.TARDIS.hads.HostileDisplacement;
import org.bukkit.entity.Player;

public class HostileAction {
    private final TARDIS plugin;

    public HostileAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void processAction(int id, Player hostile) {
        if (this.plugin.getTrackerKeeper().getHadsDamage().get(id) > 99) {
            return;
        }
        this.plugin.getTrackerKeeper().getHadsDamage().put(id, 100);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            UUID uuid = tardis.getUuid();
            boolean poweredOn = tardis.isPoweredOn();
            ChameleonPreset preset = tardis.getPreset();
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
            if (rsp.resultSet()) {
                if (rsp.isHadsOn() && poweredOn) {
                    switch (rsp.getHadsType()) {
                        case DISPLACEMENT: {
                            new HostileDisplacement(this.plugin).moveTARDIS(id, uuid, hostile, preset);
                            break;
                        }
                        case DISPERSAL: {
                            new HostileDispersal(this.plugin).disperseTARDIS(id, uuid, hostile, preset);
                            break;
                        }
                    }
                } else {
                    this.plugin.getTrackerKeeper().getHadsDamage().remove(id);
                    this.plugin.getMessenger().sendStatus(hostile, "TARDIS_BREAK");
                }
            } else {
                this.plugin.getTrackerKeeper().getHadsDamage().remove(id);
                this.plugin.getMessenger().sendStatus(hostile, "TARDIS_BREAK");
            }
        }
    }
}

